/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.bigquery;

import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.TimeDimension;
import java.util.List;

public class BigQueryDatasetConfig
extends AbstractSQLDatasetHandler.AbstractSQLConfig {
    private static final long serialVersionUID = -3L;
    public boolean forbidPreviewFallbackToSelect;
    public String externalPartitionField;
    public boolean requiresPartitionFilter;
    public boolean useBigQueryPartitioning;
    public PartitioningType bigQueryPartitioningType = PartitioningType.DATE;
    public String bigQueryPartitioningField;
    public List<BigQueryClusteringColumn> bigQueryClusteringColumns;
    public DatePartitioningPeriod bigQueryPartitioningPeriod = DatePartitioningPeriod.DAY;
    public long bigQueryPartitioningRangeStart;
    public long bigQueryPartitioningRangeEnd;
    public long bigQueryPartitioningRangeInterval;
    public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue bigQueryRequirePartitionFilter = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
    public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue forbidPartitionsWriteToNonPartitionedTable = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;

    public boolean requireBQPartitionFilter(BigQueryConnection.Params connectionParams) {
        if (!this.useBigQueryPartitioning) {
            return false;
        }
        return this.bigQueryRequirePartitionFilter.isEnabled() || this.bigQueryRequirePartitionFilter.isInherited() && connectionParams.requirePartitionFilter;
    }

    public static enum PartitioningType {
        DATE,
        RANGE;

    }

    public static enum DatePartitioningPeriod {
        YEAR,
        MONTH,
        DAY,
        HOUR;


        public static DatePartitioningPeriod fromTimeDimensionPeriod(TimeDimension.Period timeDimensionPeriod) {
            return switch (timeDimensionPeriod) {
                default -> throw new IncompatibleClassChangeError();
                case TimeDimension.Period.YEAR -> YEAR;
                case TimeDimension.Period.MONTH -> MONTH;
                case TimeDimension.Period.DAY -> DAY;
                case TimeDimension.Period.HOUR -> HOUR;
            };
        }
    }

    public static class BigQueryClusteringColumn {
        public String name;
    }
}

