/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.docextraction.StructuredContent;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.List;

@PolyJSON(value={@Mapping(type="document", value=Document.class), @Mapping(type="section", value=Section.class), @Mapping(type="text", value=Text.class), @Mapping(type="image", value=Image.class), @Mapping(type="table", value=Table.class)})
@PartOfPublicAPI
public abstract class StructuredContentDTO {
    public List<Integer> pages;
    public List<StructuredContentDTO> content;
    public StructuredContent.PageRange pageRange;

    public abstract String getType();

    public static class Table
    extends StructuredContentDTO {
        public String text;

        @Override
        public String getType() {
            return "table";
        }

        public Table() {
        }

        public Table(String text) {
            this.text = text;
        }
    }

    public static class Text
    extends StructuredContentDTO {
        public String text;

        @Override
        public String getType() {
            return "text";
        }

        public Text() {
        }

        public Text(String text) {
            this.text = text;
        }
    }

    public static class Image
    extends StructuredContentDTO {
        public InputRefs.SingleImageRef imageRef;
        public String image;
        public String mimeType;
        public String description;
        public Integer resolution;
        public Long height;
        public Long width;
        public String caption;

        @Override
        public String getType() {
            return "image";
        }

        public Image() {
        }

        public Image(String mimeType, String description, Integer resolution, Long height, Long width, String caption) {
            this.mimeType = mimeType;
            this.description = description;
            this.resolution = resolution;
            this.height = height;
            this.width = width;
            this.caption = caption;
        }
    }

    public static class Document
    extends Section {
        @Override
        public String getType() {
            return "document";
        }

        public Document() {
            this.level = 0;
        }
    }

    public static class Section
    extends StructuredContentDTO {
        public Integer level;
        public String title;

        @Override
        public String getType() {
            return "section";
        }

        public Section() {
        }

        public Section(Integer level, String title) {
            this.level = level;
            this.title = title;
        }
    }
}

