/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipeMeta;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.utils.JSON;
import java.util.stream.Collectors;

public class UpsertRecipePlaceholders {
    private UpsertRecipePlaceholders() {
    }

    public static void assertIsUpsertRecipe(SerializedRecipe sr) throws BadTemplatePlaceholderException {
        if (!UpsertRecipeMeta.META.getType().equals(sr.type)) {
            throw new BadTemplatePlaceholderException("This placeholder is only available for a Upsert recipe. " + sr.name + " has type " + sr.type + ".");
        }
    }

    public static UpsertRecipePayloadParams getPayload(FlowDocumentContext context, SerializedRecipe sr) throws PlaceholderExpectedException {
        UpsertRecipePlaceholders.assertIsUpsertRecipe(sr);
        return (UpsertRecipePayloadParams)JSON.parse((String)context.getCachedPayload(sr), UpsertRecipePayloadParams.class);
    }

    public static class UpsertKeys
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            UpsertRecipePayloadParams params = UpsertRecipePlaceholders.getPayload(context, recipe);
            return new PlaceholderOutput.Text(params.keys.stream().map(gk -> gk.column).collect(Collectors.joining(", ")));
        }
    }
}

