/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.dip.eda.worksheets.cards.ShapiroNormalityTestCard;
import com.dataiku.dip.eda.worksheets.cards.TZTest1SampCard;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OneSampleTestSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() != 1) {
            return Collections.emptyList();
        }
        SniffedVariable sniffedVariable = sniffedVariables.get(0);
        ArrayList<SuggestCards.SuggestedCard> suggestions = new ArrayList<SuggestCards.SuggestedCard>();
        if (sniffedVariable.isLikelyNumerical()) {
            suggestions.add(this.suggestShapiroWilkTest(sniffedVariable));
        }
        if (sniffedVariable.isLikelyIndicator()) {
            suggestions.add(this.suggestTZTest(sniffedVariable, 0.5));
        }
        if (sniffedVariable.isLikelyNumerical() && sniffedVariable.looksCenteredAround(0.0)) {
            suggestions.add(this.suggestTZTest(sniffedVariable, 0.0));
        }
        return suggestions;
    }

    private SuggestCards.SuggestedCard suggestShapiroWilkTest(SniffedVariable sniffed) {
        ShapiroNormalityTestCard card = new ShapiroNormalityTestCard(Suggester.toContinuousVariable(sniffed));
        return new SuggestCards.SuggestedCard("Shapiro-Wilk normality test", card);
    }

    private SuggestCards.SuggestedCard suggestTZTest(SniffedVariable sniffed, double hypothesisMean) {
        TZTest1SampCard card = new TZTest1SampCard(Suggester.toContinuousVariable(sniffed), hypothesisMean, null, AlternativeHypothesis.TWO_SIDED);
        return new SuggestCards.SuggestedCard("Student test", card);
    }
}

