/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eventserver;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.eventserver.ProcessingQueue;
import com.dataiku.dip.eventserver.dssmodel.EventServerSettings;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigurationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProcessingQueue processingQueue;
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eventserver.configuration");

    public ConfigurationServlet() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.authService.failIfNoSharedSecret(req);
        EventServerSettings ess = this.generalSettingsDAO.getUnsafeAutoTXN().eventServerSettings;
        try {
            this.processingQueue.configure(ess);
        }
        catch (Exception e) {
            logger.error((Object)("API call '" + req.getRequestURI() + "' failed"), (Throwable)e);
            try {
                DIPInternalControllerBase.sendError((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            }
            catch (Exception e2) {
                logger.error((Object)"Additional exception while sending error", (Throwable)e2);
            }
        }
    }
}

