/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.experimenttracking;

import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.experimenttracking.ExperimentTag;
import com.dataiku.dip.experimenttracking.ExperimentTrackingInternalDBNoCreate;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ExperimentTrackingInternalDB
extends ExperimentTrackingInternalDBNoCreate {
    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws SQLException {
        Statement st2;
        if (currentSchemaVersion == 0) {
            st2 = conn.createStatement();
            try {
                this.createTable("EXPERIMENTS", EXPERIMENT_COLUMNS, null, st2);
                this.createAnonymousUniqueIndex("EXPERIMENTS", EXPERIMENTS_INDEX_KEYS, st2);
                this.createTable("RUNS", RUN_COLUMNS, null, st2);
                this.createAnonymousUniqueIndex("RUNS", RUNS_INDEX_KEYS, st2);
                this.createTable("PARAMETERS", PARAMETERS_COLUMNS, null, st2);
                this.createAnonymousUniqueIndex("PARAMETERS", PARAMETERS_INDEX_KEYS, st2);
                this.createTable("METRICS", METRICS_COLUMNS, null, st2);
                this.createAnonymousUniqueIndex("METRICS", METRICS_INDEX_KEYS, st2);
                this.createTable("RUN_TAGS", RUN_TAGS_COLUMNS, null, st2);
                this.createAnonymousUniqueIndex("RUN_TAGS", RUN_TAGS_INDEX_KEYS, st2);
                this.createTable("MODELS", MODELS_COLUMNS, null, st2);
                this.createAnonymousIndex("MODELS", MODELS_INDEX_KEYS, st2);
                this.createAnonymousUniqueIndex("MODELS", MODELS_UNIQUE_ARTIFACT_PATH_INDEX_KEYS, st2);
                this.createTable("EXP_TAGS", EXPERIMENT_TAGS_COLUMNS, null, st2);
                this.createAnonymousUniqueIndex("EXP_TAGS", EXPERIMENT_TAGS_INDEX_KEYS, st2);
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
        }
        if (currentSchemaVersion == 1) {
            st2 = conn.createStatement();
            try {
                this.createTable("EXP_TAGS", EXPERIMENT_TAGS_COLUMNS, null, st2);
                this.createAnonymousUniqueIndex("EXP_TAGS", EXPERIMENT_TAGS_INDEX_KEYS, st2);
                st2.execute("SELECT " + this.quote("EXP_PROJECT_KEY") + ", " + this.quote("EXP_ID") + ", " + this.quote("EXP_TAGS") + " FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS"));
                ResultSet rs2 = st2.getResultSet();
                if (rs2 != null) {
                    while (rs2.next()) {
                        String tags = rs2.getString("EXP_TAGS");
                        if (StringUtils.isEmpty((String)tags)) continue;
                        List tagsList = (List)JSON.parse((String)tags, (TypeToken)new TypeToken<ArrayList<ExperimentTag>>(){});
                        tagsList.forEach(tag -> {
                            try {
                                this.insertUpdateExperimentTag(conn, rs2.getString("EXP_PROJECT_KEY"), rs2.getString("EXP_ID"), tag.key, tag.value);
                            }
                            catch (SQLException e) {
                                throw new RuntimeException("Unable to fill the newly created table " + this.getQuotedFullResolvedTableName("EXP_TAGS"), e);
                            }
                        });
                    }
                }
                st2.execute("ALTER TABLE " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " DROP COLUMN " + this.quote("EXP_TAGS"));
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
        }
    }
}

