/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.hooks;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.export.hooks.FileExportPostprocessingHook;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.graphicsexport.model.EnrichedExport;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class FileExportPostprocessingHookHandler {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.exports.hooks");

    public static void onPostDataExportToFile(AuthCtx authCtx, File file, ExportInput input) throws Exception {
        FileExportPostprocessingHook hook = FileExportPostprocessingHookHandler.newHook();
        if (hook != null) {
            logger.info((Object)("Running post-processing hook on data export file: " + String.valueOf(file)));
            hook.onPostDataExportToFile(authCtx, file, input);
        }
    }

    public static void onPostGraphicExport(AuthCtx authCtx, File file, EnrichedExport exportDefinition) throws Exception {
        FileExportPostprocessingHook hook = FileExportPostprocessingHookHandler.newHook();
        if (hook != null) {
            logger.info((Object)("Running post-processing hook on graphic export file: " + String.valueOf(file)));
            hook.onPostGraphicExport(authCtx, file, exportDefinition);
        }
    }

    public static void onPostModelDocumentationExport(AuthCtx authCtx, File file, FullModelId modelId) throws Exception {
        FileExportPostprocessingHook hook = FileExportPostprocessingHookHandler.newHook();
        if (hook != null) {
            logger.info((Object)("Running post-processing hook on model documentation export file: " + String.valueOf(file)));
            hook.onPostModelDocumentationExport(authCtx, file, modelId);
        }
    }

    public static void onPostFlowDocumentationExport(AuthCtx authCtx, File file, String projectKey) throws Exception {
        FileExportPostprocessingHook hook = FileExportPostprocessingHookHandler.newHook();
        if (hook != null) {
            logger.info((Object)("Running post-processing hook on flow documentation export file: " + String.valueOf(file)));
            hook.onPostFlowDocumentationExport(authCtx, file, projectKey);
        }
    }

    private static FileExportPostprocessingHook newHook() {
        String clazzName = DKUApp.getParams().getParam("dku.exports.fileExportPostprocessingHookClass");
        if (StringUtils.isBlank((String)clazzName)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            return (FileExportPostprocessingHook)clazz.newInstance();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to instantiate export hook postprocessor", (Throwable)e);
            return null;
        }
    }
}

