/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.snowpark;

import com.dataiku.common.rpc.ExternalJSONAPIClient;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.snowpark.SnowparkDeploymentStatusReporter;
import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkComputePool;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDeployedEndpoint;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDeployedUserFunction;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDetailedService;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkService;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkServiceStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSHeader;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSSigner;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.RSASSASigner;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class SnowparkUtils {
    private static final int DEFAULT_DEPLOYMENT_TIMEOUT_S = 300;
    private static final String DEFAULT_DEPLOYMENT_TIMEOUT_CONFIG_KEY = "dku.deployer.deployment.snowflake.utils.deploymentTimeoutS";
    private static final BackOffStrategy BACKOFF_STRATEGY;
    private static final DKULogger logger;

    private SnowparkUtils() {
    }

    public static SQLConnectionProvider.SQLConnectionWrapper createSQLWrapper_NT(@Nonnull SnowflakeConnection connection, @Nonnull AuthCtx authCtx, @Nonnull SnowparkAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) throws SQLException, DKUSecurityException, InterruptedException {
        return SnowparkUtils.createSQLWrapper_NT(connection, authCtx, infra.roleName, infra.warehouseName, infra.databaseName, infra.schemaName, connectTimeout, socketTimeout);
    }

    public static SQLConnectionProvider.SQLConnectionWrapper createSQLWrapper_NT(@Nonnull SnowflakeConnection connection, @Nonnull AuthCtx authCtx, @Nullable String roleName, @Nullable String warehouseName, @Nullable String databaseName, @Nullable String schemaName, int connectTimeout, int socketTimeout) throws SQLException, DKUSecurityException, InterruptedException {
        try {
            SQLConnectionProvider.SQLConnectionData cd = connection.getConnectionData_NT(authCtx, "__DKU_ANY_PROJECT__");
            if (StringUtils.isNotBlank((CharSequence)databaseName)) {
                cd.withProperty("db", databaseName);
            }
            if (StringUtils.isNotBlank((CharSequence)warehouseName)) {
                cd.withProperty("warehouse", warehouseName);
            }
            if (StringUtils.isNotBlank((CharSequence)roleName)) {
                cd.withProperty("role", roleName);
            }
            if (StringUtils.isNotBlank((CharSequence)schemaName)) {
                cd.withProperty("schema", schemaName);
            }
            cd.withProperty("net.snowflake.jdbc.http_client_connection_timeout_in_ms", String.valueOf(connectTimeout));
            cd.withProperty("net.snowflake.jdbc.http_client_socket_timeout_in_ms", String.valueOf(socketTimeout));
            return SQLConnectionProvider.newConnection(cd, authCtx, null);
        }
        catch (SQLException e) {
            throw new CodedSQLException(DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_INVALID_CONNECTION, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public static void createService_NT(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, SnowparkDetailedService service, String specification) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        SQLDialect dialect = sqlWrapper.getDialect();
        String quotedService = dialect.quoteIdentifier(service.name);
        String quotedComputePool = dialect.quoteIdentifier(service.computePoolName);
        String query = String.format("CREATE SERVICE %s IN COMPUTE POOL %s FROM SPECIFICATION $$ %s $$ MIN_INSTANCES=%s MAX_INSTANCES=%s", quotedService, quotedComputePool, specification, service.minInstances, service.maxInstances);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ps2.executeQuery();
        }
    }

    public static void dropService_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String service) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        if (StringUtils.isBlank((CharSequence)service)) {
            return;
        }
        String quotedService = sqlWrapper.getDialect().quoteIdentifier(service);
        String query = String.format("DROP SERVICE IF EXISTS %s", quotedService);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ps2.executeQuery();
        }
    }

    public static void createUdf_NT(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, String functionName, String snowparkService, String endpointName, String route) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        SQLDialect dialect = sqlWrapper.getDialect();
        String quotedUdf = dialect.quoteIdentifier(functionName);
        String quotedService = dialect.quoteString(snowparkService);
        String quotedEndpoint = dialect.quoteString(endpointName);
        String quotedRoute = dialect.quoteString(route);
        String query = String.format("CREATE FUNCTION %s(InputText varchar) RETURNS varchar SERVICE=%s ENDPOINT=%s AS %s", quotedUdf, quotedService, quotedEndpoint, quotedRoute);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ps2.executeQuery();
        }
    }

    public static void dropUdf_NT(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String functionName) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        if (StringUtils.isBlank((CharSequence)functionName)) {
            return;
        }
        String quotedUdf = sqlWrapper.getDialect().quoteIdentifier(functionName);
        String query = String.format("DROP FUNCTION IF EXISTS %s(varchar)", quotedUdf);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ps2.executeQuery();
        }
    }

    public static String callUdf_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nonnull String functionName, @Nonnull String input) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        SQLDialect dialect = sqlWrapper.getDialect();
        String quotedInput = dialect.quoteString(input);
        String quotedUdf = dialect.quoteIdentifier(functionName);
        String query = String.format("SELECT %s(%s)", quotedUdf, quotedInput);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery(query);
            if (rs2.next()) {
                String string = rs2.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Nullable
    public static SnowparkDetailedService getService_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String serviceName) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        if (!SnowparkUtils.doesServiceExist_NT(sqlWrapper, serviceName)) {
            return null;
        }
        String quotedService = sqlWrapper.getDialect().quoteIdentifier(serviceName);
        String query = String.format("DESCRIBE SERVICE %s", quotedService);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery(query);
            if (rs2.next()) {
                SnowparkDetailedService snowparkDetailedService = SnowparkUtils.mapToDetailedService(rs2);
                return snowparkDetailedService;
            }
            SnowparkDetailedService snowparkDetailedService = null;
            return snowparkDetailedService;
        }
    }

    @Nullable
    public static List<SnowparkServiceStatus> getServiceStatuses_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String serviceName) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        if (!SnowparkUtils.doesServiceExist_NT(sqlWrapper, serviceName)) {
            return null;
        }
        String quotedService = sqlWrapper.getDialect().quoteString(serviceName);
        String query = String.format("SELECT SYSTEM$GET_SERVICE_STATUS(%s)", quotedService);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery(query);
            if (rs2.next()) {
                List<SnowparkServiceStatus> list = SnowparkUtils.mapToServiceStatuses(rs2);
                return list;
            }
            List<SnowparkServiceStatus> list = null;
            return list;
        }
    }

    @Nullable
    public static SnowparkDeployedUserFunction getUserFunction_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String udfName) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        if (StringUtils.isBlank((CharSequence)udfName)) {
            return null;
        }
        List<SnowparkDeployedUserFunction> userFunctions = SnowparkUtils.listUserFunctions_NT(sqlWrapper, udfName);
        if (userFunctions.isEmpty()) {
            return null;
        }
        return userFunctions.get(0);
    }

    @Nullable
    public static String getCurrentDatabase(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        String query = "SELECT CURRENT_DATABASE()";
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery(query);
            if (rs2.next()) {
                String string = rs2.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Nullable
    public static String getCurrentSchema(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        String query = "SELECT CURRENT_SCHEMA()";
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery(query);
            if (rs2.next()) {
                String string = rs2.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Nullable
    public static String getCurrentWarehouse(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        String query = "SELECT CURRENT_WAREHOUSE()";
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery(query);
            if (rs2.next()) {
                String string = rs2.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    public static boolean doesServiceExist_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String serviceName) throws SQLException {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            return false;
        }
        return !SnowparkUtils.listServices_NT(sqlWrapper, serviceName).isEmpty();
    }

    @Nonnull
    public static List<SnowparkService> listServices_NT(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper) throws SQLException {
        return SnowparkUtils.listServices_NT(sqlWrapper, null);
    }

    @Nonnull
    public static List<ExternalInfraEndpoint> listEndpoints_NT(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        SQLDialect dialect = sqlWrapper.getDialect();
        List<SnowparkService> services = SnowparkUtils.listServices_NT(sqlWrapper);
        ArrayList<ExternalInfraEndpoint> externalInfraEndpoints = new ArrayList<ExternalInfraEndpoint>();
        for (SnowparkService service : services) {
            List<SnowparkServiceStatus> statuses = SnowparkUtils.getServiceStatuses_NT(sqlWrapper, service.name);
            Pair<DeploymentHealth, InfoMessage.InfoMessages> healthAndMessages = SnowparkDeploymentStatusReporter.checkServiceStatusesHealth(statuses);
            List endpoints = SnowparkUtils.getEndpointsInfo_NT(sqlWrapper, service.name).stream().map(e -> {
                String endpointName = SnowparkUtils.getEndpointUniqueName(e.name, service.name);
                String endpointFullId = SnowparkUtils.getEndpointFullId(e.name, service.name, service.databaseName, service.schemaName, dialect);
                String resourceLink = e.ingressUrl != null ? "https://" + e.ingressUrl : null;
                return new ExternalInfraEndpoint(null, endpointName, endpointFullId, (DeploymentHealth)((Object)((Object)healthAndMessages.first)), (InfoMessage.InfoMessages)healthAndMessages.second, resourceLink);
            }).collect(Collectors.toList());
            externalInfraEndpoints.addAll(endpoints);
        }
        return externalInfraEndpoints;
    }

    @Nonnull
    private static String getQualifiedName(@Nonnull String name, @Nonnull String database, @Nonnull String schema, @Nonnull SQLDialect dialect) {
        String quotedName = dialect.quoteIdentifier(name);
        String quotedDatabase = dialect.quoteIdentifier(database);
        String quotedSchema = dialect.quoteIdentifier(schema);
        return String.format("%s.%s.%s", quotedDatabase, quotedSchema, quotedName);
    }

    private static String getEndpointFullId(@Nonnull String endpointName, @Nonnull String serviceName, @Nonnull String database, @Nonnull String schema, @Nonnull SQLDialect dialect) {
        String serviceQualifiedName = SnowparkUtils.getQualifiedName(serviceName, database, schema, dialect);
        return String.format("%s.%s", serviceQualifiedName, endpointName);
    }

    private static String getEndpointUniqueName(@Nonnull String endpointName, @Nonnull String serviceName) {
        return String.format("%s.%s", serviceName, endpointName);
    }

    @Nullable
    public static String getPublicEndpointUrl_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String service, @Nonnull String endpoint) throws InterruptedException, SQLException, IOException {
        SnowparkDeployedEndpoint endpointInfo = SnowparkUtils.getPublicEndpoint_NT(sqlWrapper, service, endpoint);
        return endpointInfo != null ? endpointInfo.ingressUrl : null;
    }

    public static void waitABitUntilServiceIsReady_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String serviceName) throws SQLException, IOException, InterruptedException {
        SnowparkServiceStatus status = SnowparkServiceStatus.getWorse(SnowparkUtils.getServiceStatuses_NT(sqlWrapper, serviceName));
        BackOff backOff = BACKOFF_STRATEGY.build();
        while ("PENDING".equalsIgnoreCase(status != null ? status.status : null)) {
            long millis = backOff.nextBackOffMillis();
            if (millis <= 0L) {
                return;
            }
            Thread.sleep(millis);
            status = SnowparkServiceStatus.getWorse(SnowparkUtils.getServiceStatuses_NT(sqlWrapper, serviceName));
        }
    }

    @Nullable
    public static SnowparkDeployedEndpoint getPublicEndpoint_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String service, @Nonnull String endpointName) throws InterruptedException, SQLException, IOException {
        TransactionContext.assertNoAttachedTransaction();
        SnowparkDeployedEndpoint endpoint = SnowparkUtils.getEndpointInfo_NT(sqlWrapper, service, endpointName);
        BackOff backOff = BACKOFF_STRATEGY.build();
        while ("Endpoints provisioning in progress... check back in a few minutes".equals(endpoint != null ? endpoint.ingressUrl : null)) {
            long millis = backOff.nextBackOffMillis();
            if (millis <= 0L) {
                return endpoint;
            }
            Thread.sleep(millis);
            endpoint = SnowparkUtils.getEndpointInfo_NT(sqlWrapper, service, endpointName);
        }
        return endpoint;
    }

    public static boolean isImageRepositoryAccessible_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String imageRepositoryURL) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        if (StringUtils.isBlank((CharSequence)imageRepositoryURL)) {
            return false;
        }
        String query = "SHOW IMAGE REPOSITORIES IN ACCOUNT";
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
                String repositoryUrl = rs2.getString("repository_url");
                if (!imageRepositoryURL.equals(repositoryUrl)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Nullable
    public static SnowparkComputePool getComputePool_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String computePoolName) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        if (StringUtils.isBlank((CharSequence)computePoolName)) {
            return null;
        }
        String quotedComputePool = sqlWrapper.getDialect().quoteString(computePoolName);
        String query = String.format("SHOW COMPUTE POOLS LIKE %s", quotedComputePool);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery(query);
            if (rs2.next()) {
                SnowparkComputePool snowparkComputePool = SnowparkUtils.mapToComputePool(rs2);
                return snowparkComputePool;
            }
            SnowparkComputePool snowparkComputePool = null;
            return snowparkComputePool;
        }
    }

    private static PrivateKey extractPrivateKeyWithBouncyCastle(byte[] privateKeyBytes, String privateKeyPwd) throws IOException, PKCSException, OperatorCreationException {
        PrivateKeyInfo privateKeyInfo;
        block8: {
            logger.info((Object)"Extracting private key using Bouncy Castle provider");
            privateKeyInfo = null;
            try (PEMParser pemParser = new PEMParser((Reader)new StringReader(new String(privateKeyBytes, StandardCharsets.UTF_8)));){
                Object pemObject = pemParser.readObject();
                if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                    PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObject;
                    InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(privateKeyPwd.toCharArray());
                    privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(pkcs8Prov);
                    break block8;
                }
                if (pemObject instanceof PEMKeyPair) {
                    privateKeyInfo = ((PEMKeyPair)pemObject).getPrivateKeyInfo();
                    break block8;
                }
                if (pemObject instanceof PrivateKeyInfo) {
                    privateKeyInfo = (PrivateKeyInfo)pemObject;
                    break block8;
                }
                throw new IOException("PEM parser for the private key leads to an unexpected object " + String.valueOf(pemObject));
            }
        }
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        return converter.getPrivateKey(privateKeyInfo);
    }

    public static String getSnowflakeKeyPairToken(SnowflakeConnection connection, SnowflakeConnection.SerializableSnowflakeCredentials creds) throws DKUSecurityException {
        byte[] key = Base64.getDecoder().decode(creds.privateKeyB64);
        String account = connection.getAccountIdentifier().toUpperCase().replace(".", "-");
        String user = creds.user.toUpperCase();
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PrivateKey privateKey = SnowparkUtils.extractPrivateKeyWithBouncyCastle(key, creds.privateKeyPassword);
            RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(rsaPublicKeySpec);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedHash = digest.digest(publicKey.getEncoded());
            JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
            String sub = String.format("%s.%s", account, user);
            String iss = String.format("%s.%s.%s", account, user, "SHA256:" + Base64.getEncoder().encodeToString(encodedHash));
            Date iat = new Date(System.currentTimeMillis());
            Date exp = new Date(iat.getTime() + 3600000L);
            JWTClaimsSet claimsSet = builder.issuer(iss).subject(sub).issueTime(iat).expirationTime(exp).build();
            SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
            RSASSASigner signer = new RSASSASigner(privateKey);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (Exception exc) {
            throw new DKUSecurityException("Unable to generate a JWT token", (Throwable)exc);
        }
    }

    @Nonnull
    public static JsonObject getSnowflakeToken_NT(@Nonnull AuthCtx authCtx, @Nonnull SnowflakeConnection connection) throws IOException, DKUSecurityException {
        JsonObject tokenResponse;
        TransactionContext.assertNoAttachedTransaction();
        SnowflakeConnection.SerializableSnowflakeCredentials creds = connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), SnowflakeConnection.SerializableSnowflakeCredentials.class);
        SnowflakeConnection.Params params = connection.getParams();
        String loginUrl = "https://" + params.host;
        JsonObject tokenRequestBody = new JsonObject();
        switch (creds.authType) {
            case OAUTH2_APP: {
                tokenRequestBody.addProperty("AUTHENTICATOR", "OAUTH");
                tokenRequestBody.addProperty("TOKEN", creds.oauth2AccessToken);
                break;
            }
            case PASSWORD: {
                tokenRequestBody.addProperty("LOGIN_NAME", creds.user);
                tokenRequestBody.addProperty("PASSWORD", creds.password);
                break;
            }
            case KEY_PAIR: {
                tokenRequestBody.addProperty("AUTHENTICATOR", "SNOWFLAKE_JWT");
                tokenRequestBody.addProperty("TOKEN", SnowparkUtils.getSnowflakeKeyPairToken(connection, creds));
                break;
            }
        }
        JsonObject tokenRequest = new JsonObject();
        tokenRequest.add("data", (JsonElement)tokenRequestBody);
        try (ExternalJSONAPIClient loginClient = new ExternalJSONAPIClient(loginUrl, null, true, connection.getProxySettings());){
            tokenResponse = (JsonObject)loginClient.postObjectToJSON("session/v1/login-request", JsonObject.class, (Object)tokenRequest);
        }
        if (!tokenResponse.get("success").getAsBoolean()) {
            throw new IOException("Unable to acquire Snowflake token :" + tokenResponse.toString());
        }
        return tokenResponse.get("data").getAsJsonObject();
    }

    @Nonnull
    private static List<SnowparkDeployedEndpoint> getEndpointsInfo_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String service) throws SQLException {
        if (StringUtils.isBlank((CharSequence)service)) {
            return new ArrayList<SnowparkDeployedEndpoint>();
        }
        ArrayList<SnowparkDeployedEndpoint> endpoints = new ArrayList<SnowparkDeployedEndpoint>();
        String quotedService = sqlWrapper.getDialect().quoteIdentifier(service);
        String query = String.format("SHOW ENDPOINTS IN SERVICE %s", quotedService);
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, query);){
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
                SnowparkDeployedEndpoint endpointInfo = SnowparkUtils.mapToEndpoint(rs2);
                endpoints.add(endpointInfo);
            }
            ArrayList<SnowparkDeployedEndpoint> arrayList = endpoints;
            return arrayList;
        }
    }

    @Nullable
    private static SnowparkDeployedEndpoint getEndpointInfo_NT(@Nonnull SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String service, @Nonnull String endpoint) throws SQLException {
        List<SnowparkDeployedEndpoint> endpoints = SnowparkUtils.getEndpointsInfo_NT(sqlWrapper, service);
        for (SnowparkDeployedEndpoint endpointInfo : endpoints) {
            if (!endpointInfo.name.equals(endpoint)) continue;
            return endpointInfo;
        }
        return null;
    }

    private static SnowparkService mapToService(@Nonnull ResultSet rs2) throws SQLException {
        String name = rs2.getString("name");
        String computePool = rs2.getString("compute_pool");
        String databaseName = rs2.getString("database_name");
        String schemaName = rs2.getString("schema_name");
        int minInstances = rs2.getInt("min_instances");
        int maxInstances = rs2.getInt("max_instances");
        return new SnowparkService(name, databaseName, schemaName, computePool, minInstances, maxInstances);
    }

    private static SnowparkDeployedEndpoint mapToEndpoint(@Nonnull ResultSet rs2) throws SQLException {
        String name = rs2.getString("name");
        String url = rs2.getString("ingress_url");
        int port = rs2.getInt("port");
        return new SnowparkDeployedEndpoint(name, url, port);
    }

    private static SnowparkDeployedUserFunction mapToUdf(@Nonnull ResultSet rs2) throws SQLException {
        String name = rs2.getString("name");
        String schema = rs2.getString("schema_name");
        return new SnowparkDeployedUserFunction(name, schema);
    }

    private static SnowparkDetailedService mapToDetailedService(@Nonnull ResultSet rs2) throws SQLException {
        String name = rs2.getString("name");
        String computePool = rs2.getString("compute_pool");
        String databaseName = rs2.getString("database_name");
        String schemaName = rs2.getString("schema_name");
        int minInstances = rs2.getInt("min_instances");
        int maxInstances = rs2.getInt("max_instances");
        String spec = rs2.getString("spec");
        return SnowparkDetailedService.buildFromSpecification(name, databaseName, schemaName, computePool, minInstances, maxInstances, spec);
    }

    private static SnowparkComputePool mapToComputePool(@Nonnull ResultSet rs2) throws SQLException {
        String name = rs2.getString("name");
        String state = rs2.getString("state");
        return new SnowparkComputePool(name, state);
    }

    @Nullable
    private static List<SnowparkServiceStatus> mapToServiceStatuses(@Nonnull ResultSet rs2) throws SQLException {
        String content = rs2.getString(1);
        return (List)JSON.parse((String)content, (TypeToken)new TypeToken<List<SnowparkServiceStatus>>(){});
    }

    @Nonnull
    private static List<SnowparkService> listServices_NT(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String serviceName) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        ArrayList<SnowparkService> services = new ArrayList<SnowparkService>();
        Object query = "SHOW SERVICES";
        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            String quotedService = sqlWrapper.getDialect().quoteString(serviceName);
            query = (String)query + String.format(" LIKE %s", quotedService);
        }
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, (String)query);){
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
                SnowparkService service = SnowparkUtils.mapToService(rs2);
                services.add(service);
            }
        }
        return services;
    }

    @Nonnull
    private static List<SnowparkDeployedUserFunction> listUserFunctions_NT(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String udfName) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        ArrayList<SnowparkDeployedUserFunction> udfs = new ArrayList<SnowparkDeployedUserFunction>();
        Object query = "SHOW USER FUNCTIONS";
        if (StringUtils.isNotBlank((CharSequence)udfName)) {
            String quotedUdf = sqlWrapper.getDialect().quoteString(udfName);
            query = (String)query + String.format(" LIKE %s", quotedUdf);
        }
        try (PreparedStatement ps2 = SnowparkUtils.prepareStatementAndLogQuery(sqlWrapper, (String)query);){
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
                SnowparkDeployedUserFunction userFunction = SnowparkUtils.mapToUdf(rs2);
                udfs.add(userFunction);
            }
        }
        return udfs;
    }

    private static PreparedStatement prepareStatementAndLogQuery(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, String query) throws SQLException {
        logger.infoV("Run Snowflake query: %s", new Object[]{query});
        return sqlWrapper.prepareStatement(query);
    }

    static {
        int backOffTimeoutS = DKUApp.getParams().getIntParam(DEFAULT_DEPLOYMENT_TIMEOUT_CONFIG_KEY, Integer.valueOf(300));
        BACKOFF_STRATEGY = BackOffStrategy.expBackOff((int)5000, (int)15000, (double)1.015, (int)(backOffTimeoutS * 1000));
        logger = DKULogger.getLogger((String)"dku.deployer.deployment.snowpark.utils");
    }
}

