/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.HashMap;
import java.util.Map;

public abstract class HiveMetastoreSynchronizer
implements AutoCloseable {
    private static final Map<String, Object> tableLocks = new HashMap<String, Object>();

    public abstract InfoMessage.InfoMessages synchronizeOneDataset(Dataset var1, boolean var2, boolean var3, SynchronizeOneDatasetPartitionReason var4, WarningsContext var5, boolean var6) throws Exception;

    public abstract void dropExternalTable(Dataset var1) throws Exception;

    public abstract void dropTableIfExists(Dataset var1) throws Exception;

    public abstract void dropPartitionIfExistsNoFail(Dataset var1, Partition var2) throws Exception;

    public abstract void synchronizeOneDatasetPartition(Dataset var1, Partition var2, boolean var3, SynchronizeOneDatasetPartitionReason var4, WarningsContext var5, boolean var6) throws Exception;

    protected static synchronized Object getTableLock(String tableFullName) {
        Object o = tableLocks.get(tableFullName);
        if (o == null) {
            o = new Object();
            tableLocks.put(tableFullName, o);
        }
        return o;
    }

    @Override
    public void close() throws Exception {
    }

    public static class HiveSchemaCompatibility {
        public boolean unknown;
        public boolean tableExists;
        public boolean schemaCompatible;
    }

    public static enum SynchronizeOneDatasetPartitionReason {
        PRESYNCHRONIZE_WRITE_BY_HS2_TARGET,
        PRESYNCHRONIZE_WRITE_BY_IMPALA_TARGET,
        OTHER;

    }
}

