/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveSerdeShims;
import org.apache.log4j.Logger;

public class HiveSerdeShimsLoader {
    private static final String[] shimsClasses = new String[]{"com.dataiku.dip.hive.shims.Hive3SerdeShims", "com.dataiku.dip.hive.shims.HiveDefaultSerdeShims"};
    private static HiveSerdeShims shims = null;
    private static Logger logger = Logger.getLogger((String)"dip.hive.shims");

    private static void load() {
        for (String className : shimsClasses) {
            try {
                Class<?> clazz = Class.forName(className);
                shims = (HiveSerdeShims)clazz.newInstance();
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.warn((Object)("Unable to laod shims " + className));
            }
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_SERDE_CLASS_NOT_AVAILABLE, "unable to load shims for hive");
    }

    public static HiveSerdeShims get() {
        if (shims == null) {
            HiveSerdeShimsLoader.load();
        }
        return shims;
    }
}

