/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.orcfile;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.input.formats.SplitBasedFixedSchemaDetector;
import com.dataiku.dip.input.formats.hive.HiveFormatExtractor;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileSchemaDetector;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.RecordReader;

public class ORCFileFormatExtractor
extends HiveFormatExtractor<ORCFileFormatConfig>
implements SplitBasedFixedSchemaDetector {
    public ORCFileFormatExtractor(ORCFileFormatConfig config) {
        super(config);
    }

    @Override
    public InputFormat<Writable, Writable> createInputFormat() {
        return new OrcInputFormat();
    }

    @Override
    public Writable getKey(Object serde, RecordReader<Writable, Writable> recordReader) {
        Writable key = (Writable)recordReader.createKey();
        if (!(key instanceof NullWritable)) {
            throw new RuntimeException("Expected NullWritable, got " + String.valueOf(key.getClass()) + " recordReader is " + String.valueOf(recordReader.getClass()));
        }
        return key;
    }

    @Override
    public Writable getValue(Object serde, RecordReader<Writable, Writable> recordReader) {
        Writable value = (Writable)recordReader.createValue();
        if (!"org.apache.hadoop.hive.ql.io.orc.OrcStruct".equals(value.getClass().getCanonicalName())) {
            throw new RuntimeException("Expected OrcStruct, got " + String.valueOf(value.getClass()) + " recordReader is " + String.valueOf(recordReader.getClass()));
        }
        return value;
    }

    @Override
    protected Schema inferSchema(FileSystem fs, Path hdfsPath) throws IOException {
        ORCFileSchemaDetector detector = new ORCFileSchemaDetector();
        return detector.detect((ORCFileFormatConfig)this.getConfig(), fs, hdfsPath);
    }

    @Override
    public Schema detectSchema(StreamsInputSplit splitStream) throws Exception {
        EnrichedInputStream eis = splitStream.nextStream();
        if (eis == null) {
            return null;
        }
        if (!(eis instanceof HDFSProvider.HDFSInputStream)) {
            throw ErrorContext.iae((String)"This format not supported on non-HDFS datasets");
        }
        Path hdfsPath = ((HDFSProvider.HDFSInputStream)eis).getFSPath();
        FileSystem fs = ((HDFSProvider.HDFSInputStream)eis).getFS();
        return new ORCFileSchemaDetector().detect((ORCFileFormatConfig)this.getConfig(), fs, hdfsPath);
    }
}

