/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.sequencefile;

import com.dataiku.dip.input.formats.BinaryHeader;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatConfig;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatMeta;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class SequenceFileFormatDetector {
    private static final byte[] SEQUENCEFILE_MAGIC = new byte[]{83, 69, 81};

    public Collection<? extends InputFormatsDetector.FormatWithMetadata> detect(BinaryHeader header) {
        if (header.bytes.length < 3) {
            return Collections.emptyList();
        }
        if (Arrays.equals(SEQUENCEFILE_MAGIC, Arrays.copyOfRange(header.bytes, 0, 3))) {
            InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
            fwm.detectionScore = 600.0;
            fwm.params = new SequenceFileFormatConfig();
            fwm.type = SequenceFileFormatMeta.META.getType();
            fwm.metadata = new HashMap<String, String>();
            return Arrays.asList(fwm);
        }
        return Collections.emptyList();
    }
}

