/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.utils;

import com.dataiku.dip.input.stream.DecodedInputStreamFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.partitioning.Partition;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.ArchiveInputStream;

public class InputStreamEnrichedStream
implements EnrichedInputStream {
    InputStream is;
    Map<String, String> metas = new HashMap<String, String>();
    String filename;
    Partition partition;
    LongSupplier lastModifiedSupplier;

    public InputStreamEnrichedStream(InputStream is) {
        this.is = is;
    }

    public InputStreamEnrichedStream withFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public InputStreamEnrichedStream withLastModifiedSupplier(LongSupplier lastModifiedSupplier) {
        this.lastModifiedSupplier = lastModifiedSupplier;
        return this;
    }

    public boolean repeatable() {
        return false;
    }

    public String desc() {
        return "InputStream";
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPathWithinProvider() {
        return this.filename;
    }

    @Nonnull
    public LongSupplier getLastModifiedSupplier() {
        if (this.lastModifiedSupplier == null) {
            return () -> 0L;
        }
        return this.lastModifiedSupplier;
    }

    public InputStreamEnrichedStream withMeta(String k, String v) {
        this.metas.put(k, v);
        return this;
    }

    public Map<String, String> metas() {
        return this.metas;
    }

    public InputStream decompressedStream() throws IOException {
        return new DecodedInputStreamFactory().addDecoding(this.getCompression(), this.is);
    }

    public InputStream rawStream() throws IOException {
        return this.is;
    }

    public long size() {
        return -1L;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public InputStream decompressedHeadStream(long targetSize) throws IOException {
        return this.decompressedStream();
    }

    public EnrichedInputStream.Compression getCompression() {
        return EnrichedInputStream.Compression.getCompression((String)this.filename);
    }

    public boolean isArchive() {
        return false;
    }

    public ArchiveInputStream archiveContent() {
        throw new IllegalStateException();
    }

    public InputStream rawHeadStream(long targetSize) throws IOException {
        return this.is;
    }
}

