/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.input.stream.CloseableLineReader;
import java.io.IOException;
import java.io.Reader;

public class StupidBoundedBufferedReader
implements CloseableLineReader {
    private Reader br;
    private char[] buffer;
    private int bufAvailableLen = 0;
    private boolean hadHugeLine;
    private int maxLen;
    private boolean usedCRLF = false;

    public StupidBoundedBufferedReader(int maxLen, Reader br) {
        this.br = br;
        this.maxLen = maxLen;
        this.buffer = new char[maxLen + 1];
    }

    public String readLine() throws IOException {
        int bufIdx;
        assert (this.bufAvailableLen < this.buffer.length);
        int read = this.br.read(this.buffer, this.bufAvailableLen, this.buffer.length - this.bufAvailableLen);
        if (read <= 0 && this.bufAvailableLen == 0) {
            return null;
        }
        if (read > 0) {
            this.bufAvailableLen += read;
        }
        assert (this.bufAvailableLen > 0);
        String s = null;
        for (bufIdx = 0; bufIdx < this.bufAvailableLen; ++bufIdx) {
            char c2 = this.buffer[bufIdx];
            if (c2 == '\r') {
                if (this.bufAvailableLen > bufIdx + 1 && this.buffer[bufIdx + 1] == '\n') {
                    s = new String(this.buffer, 0, bufIdx);
                    ++bufIdx;
                    this.usedCRLF = true;
                } else if (this.bufAvailableLen > bufIdx + 1 || !this.usedCRLF) {
                    s = new String(this.buffer, 0, bufIdx);
                }
            } else if (c2 == '\r' && !this.usedCRLF) {
                s = new String(this.buffer, 0, bufIdx);
            } else if (c2 == '\n') {
                s = new String(this.buffer, 0, bufIdx);
            }
            if (s == null) continue;
            System.arraycopy(this.buffer, ++bufIdx, this.buffer, 0, this.bufAvailableLen - bufIdx);
            this.bufAvailableLen -= bufIdx;
            return s;
        }
        if (bufIdx >= this.maxLen) {
            this.hadHugeLine = true;
            s = new String(this.buffer, 0, this.maxLen);
            return s;
        }
        s = new String(this.buffer, 0, bufIdx);
        System.arraycopy(this.buffer, bufIdx, this.buffer, 0, this.bufAvailableLen - bufIdx);
        this.bufAvailableLen -= bufIdx;
        return s;
    }

    public boolean hadHugeLine() {
        return this.hadHugeLine;
    }

    public void close() throws IOException {
        this.br.close();
    }
}

