/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedLabelingTasksDAO
extends AbstractStandardDAO<LabelingTask>
implements LabelingTasksDAO {
    @Autowired
    private FlowGraphService graphService;

    @Override
    protected LabelingTask getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        LabelingTask lt = unsafe ? (LabelingTask)tr.readObjectUnsafe(rf, LabelingTask.class) : (LabelingTask)tr.readObject(rf, LabelingTask.class);
        lt.id = id;
        lt.projectKey = projectKey;
        return lt;
    }

    @Override
    protected List<LabelingTask> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile labelingTasksFolder = this.labelingTasksFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<LabelingTask> ret = new ArrayList<LabelingTask>();
        if (tr.isDirectory(labelingTasksFolder)) {
            for (RelFile f : tr.listFiles(labelingTasksFolder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    LabelingTask task = (LabelingTask)this.getMandatory(projectKey, id, unsafe);
                    ret.add(task);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read labeling task file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Labeling task id is not specified");
        return new RelFile(this.labelingTasksFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.LABELING_TASK.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        RelFile labelingTaskFile = this.getDAOFile(projectKey, id);
        t.deleteFile(labelingTaskFile);
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile labelingTasksFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(labelingTasksFolder = this.labelingTasksFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(labelingTasksFolder).size();
    }

    @Override
    public void save(LabelingTask labelingTask) throws IOException {
        this.graphService.invalidateCache();
        super.save(labelingTask);
    }

    private RelFile labelingTasksFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "labeling_tasks"});
    }

    static {
        DKUtils.forceInit(LabelingTask.class);
    }
}

