/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.lambda.mgmt;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSCustomPythonPredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSCustomRPredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedLambdaServicesDAO
extends AbstractStandardDAO<LambdaService>
implements LambdaServicesDAO {
    @Override
    public List<LambdaService> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile rf = this.lambdaServicesFolder(projectKey);
        ArrayList<LambdaService> ret = new ArrayList<LambdaService>();
        if (tr.isDirectory(rf)) {
            for (RelFile f : tr.listFiles(rf)) {
                if (!f.getLeafName().endsWith(".json")) continue;
                try {
                    LambdaService s = this.readService(f, projectKey, unsafe, false);
                    ret.add(s);
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Failed to read lambda service " + String.valueOf(f)), (Throwable)e);
                    LambdaService s = new LambdaService(f.getLeafName(), "Loading error: " + e.getMessage());
                    ret.add(s);
                }
            }
        }
        return ret;
    }

    @Override
    protected void write(RWTransactionRef t, LambdaService object) throws IOException {
        RelFile file = this.getDAOFile(object.getProjectKey(), object.getId());
        t.writeStringUTF8(file, JSON.forFilePrettyWithNulls((Object)object));
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile rf;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(rf = this.lambdaServicesFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(rf, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public LambdaService getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        return this.readService(rf, projectKey, unsafe, true);
    }

    @Override
    public void save(LambdaService config) throws IOException {
        assert (config.projectKey != null);
        assert (config.id != null);
        this.writeCustomCode(config.projectKey, config.id, config);
        super.save(config);
    }

    public void save_noCode(LambdaService config) throws IOException {
        assert (config.projectKey != null);
        assert (config.id != null);
        super.save(config);
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.deleteFile(this.getDAOFile(projectKey, id));
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.LAMBDA_SERVICE.toHumanReadableString();
    }

    private void writeCustomCode(String projectKey, String id, LambdaService config) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        for (DSSLambdaEndpointConfig endpoint : config.endpoints) {
            String code;
            if (endpoint.type == LambdaEndpointConfig.EndpointType.CUSTOM_PREDICTION) {
                code = ((DSSCustomPythonPredictionEndpointConfig)endpoint).code;
                tr.writeStringUTF8(this.endpointFile(projectKey, id, endpoint.id), code);
                continue;
            }
            if (endpoint.type != LambdaEndpointConfig.EndpointType.CUSTOM_R_PREDICTION) continue;
            code = ((DSSCustomRPredictionEndpointConfig)endpoint).code;
            tr.writeStringUTF8(this.endpointFile(projectKey, id, endpoint.id), code);
        }
    }

    private void readCustomCode(String projectKey, String id, LambdaService config) throws IOException {
        for (DSSLambdaEndpointConfig endpoint : config.endpoints) {
            TransactionRef tr;
            RelFile rf;
            if (endpoint.type == LambdaEndpointConfig.EndpointType.CUSTOM_PREDICTION) {
                rf = this.endpointFile(projectKey, id, endpoint.id);
                tr = TransactionContext.retrieveRead();
                if (tr.isFile(rf)) {
                    ((DSSCustomPythonPredictionEndpointConfig)endpoint).code = tr.readStringUTF8(rf);
                    continue;
                }
                throw ErrorContext.iae((String)("Did not find code " + String.valueOf(rf)));
            }
            if (endpoint.type != LambdaEndpointConfig.EndpointType.CUSTOM_R_PREDICTION) continue;
            rf = this.endpointFile(projectKey, id, endpoint.id);
            tr = TransactionContext.retrieveRead();
            if (tr.isFile(rf)) {
                ((DSSCustomRPredictionEndpointConfig)endpoint).code = tr.readStringUTF8(rf);
                continue;
            }
            throw ErrorContext.iae((String)("Did not find code " + String.valueOf(rf)));
        }
    }

    private LambdaService readService(RelFile rf, String projectKey, boolean unsafe, boolean withCode) throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        LambdaService s = unsafe ? (LambdaService)tr.readObjectUnsafe(rf, LambdaService.class) : (LambdaService)tr.readObject(rf, LambdaService.class);
        s.id = rf.getLeafName().replace(".json", "");
        s.projectKey = projectKey;
        if (StringUtils.isBlank((String)s.name)) {
            s.name = s.id;
        }
        if (withCode) {
            this.readCustomCode(projectKey, s.id, s);
        }
        return s;
    }

    private RelFile lambdaServicesFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "lambda_services"});
    }

    private RelFile endpointFile(String projectKey, String id, String endpointId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"API service id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)endpointId), (Object)"API endpoint id is not specified");
        return new RelFile(this.lambdaServicesFolder(projectKey), new String[]{id, "endpoint-" + endpointId + ".py"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"API service id is not specified");
        return new RelFile(this.lambdaServicesFolder(projectKey), new String[]{id + ".json"});
    }
}

