/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.preprocessing.SentenceEmbeddingModelMeta;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.savedmodels.SavedModelsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ConnectionsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PretrainedModelsService {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private SavedModelsService savedModelsService;
    @Autowired
    private ConnectionsService connectionsService;

    public Map<String, SentenceEmbeddingModelMeta> getCodeEnvResourcesSentenceEmbeddingModels(AuthCtx authCtx, String envName, String projectKey) throws Exception {
        String versionId = null;
        try {
            CodeEnvModel.CodeEnvResourcesModelsMeta modelsMeta;
            this.permissionsService.checkCodeEnvPrivileges(authCtx, CodeEnvModel.EnvLang.PYTHON, envName, Privileges.CodeEnvLevelPrivilegeType.USE);
            ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
            switch (nodeType) {
                case AUTOMATION: {
                    CodeEnvModel.EnvVersionRef versionRef;
                    if (projectKey == null) {
                        throw new IllegalArgumentException("Project key must be specified for code env based models on the Automation node.");
                    }
                    String bundleId = null;
                    if (CommonBundleUtils.hasActiveBundle(projectKey)) {
                        bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
                    }
                    AutomationNodeCodeEnvsService automationNodeEnvsService = (AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class);
                    CodeEnvModel.AutomationEnvRootDef env = automationNodeEnvsService.getEnvRootDef(CodeEnvModel.EnvLang.PYTHON, envName);
                    if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED && StringUtils.isNotBlank((String)bundleId) && (versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId)) != null) {
                        versionId = versionRef.envVersion;
                    }
                    modelsMeta = automationNodeEnvsService.getResourcesModelsMeta(CodeEnvModel.EnvLang.PYTHON, envName, versionId);
                    if (StringUtils.isBlank(versionId)) {
                        this.auditTrailService.generic("admin-code-env-get-resources-models-meta").with("envName", envName).emit();
                        break;
                    }
                    this.auditTrailService.generic("admin-code-env-get-resources-models-meta").with("envName", envName).with("versionId", versionId).emit();
                    break;
                }
                case DESIGN: {
                    DesignNodeCodeEnvsService designNodeEnvsService = (DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class);
                    modelsMeta = designNodeEnvsService.getResourcesModelsMeta(envName);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unreachable. This should never be called on '" + String.valueOf((Object)nodeType) + "' node.");
                }
            }
            return modelsMeta.sentence_transformers;
        }
        catch (Exception e) {
            if (StringUtils.isBlank(versionId)) {
                this.auditTrailService.failure("admin-code-env-get-resources-models-meta", (Throwable)e).with("envName", envName).emit();
            } else {
                this.auditTrailService.failure("admin-code-env-get-resources-models-meta", (Throwable)e).with("envName", envName).with("versionId", versionId).emit();
            }
            throw e;
        }
    }

    public ModelsList listAvailableLLMs(AuthCtx authCtx, String projectKey, AbstractLLMConnection.LLMUsagePurpose purpose) throws IOException, DKUSecurityException {
        ModelsList modelsList = new ModelsList();
        modelsList.identifiers.addAll(this.connectionsService.listAvailableConnectionLLMs(authCtx, purpose));
        if (StringUtils.isNotBlank((String)projectKey)) {
            modelsList.identifiers.addAll(this.savedModelsService.listAvailableSMLLMs(authCtx, projectKey, purpose));
        }
        return modelsList;
    }

    public ModelsList listAvailableConnectionLLMs(AuthCtx ctx, AbstractLLMConnection.LLMUsagePurpose purpose) throws IOException {
        ModelsList modelsList = new ModelsList();
        modelsList.identifiers.addAll(this.connectionsService.listAvailableConnectionLLMs(ctx, purpose));
        return modelsList;
    }

    public static class ModelsList {
        public List<EnrichedLLMStructuredRef> identifiers = new ArrayList<EnrichedLLMStructuredRef>();
    }
}

