/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.custom;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomJavaElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.llm.custom.CustomJavaLLMDesc;
import com.dataiku.dip.llm.custom.CustomLLMTypesRegistry;
import com.dataiku.dip.llm.custom.LoadedJavaLLM;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomJavaLLMsService
extends CustomJavaElementService<CustomJavaLLMDesc, LoadedJavaLLM> {
    @Override
    public String getFolderName() {
        return "java-llms";
    }

    @Override
    public String getPrefix() {
        return "jllm";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "jllm_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomJavaLLMDesc> getDescClass() {
        return CustomJavaLLMDesc.class;
    }

    @Override
    public Class<LoadedJavaLLM> getLoadedDescClass() {
        return LoadedJavaLLM.class;
    }

    @Override
    protected void removeElement(LoadedJavaLLM loaded) {
        FormatFactory.deregisterFormatType(loaded.getType());
    }

    @Override
    protected LoadedJavaLLM load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedJavaLLM loaded = new LoadedJavaLLM(elementType, pluginId, elementId, (CustomJavaLLMDesc)JSON.parseFile((File)file, CustomJavaLLMDesc.class));
        CustomLLMTypesRegistry.register(loaded, this);
        return loaded;
    }

    @Override
    protected String getCodeExtension(LoadedJavaLLM desc) {
        return ".java";
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomJavaLLMDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomJavaLLMsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

