/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeUtils;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedRWLock;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeBankManagementService {
    public static final String SINGLE_VERSION = "single-version";
    private final Map<String, Long> recentlyUsedFolderPaths = Collections.synchronizedMap(new HashMap());
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("KBVersionsCleaner").build());
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.knowledgebank.management");

    private void markAsRecentlyUsed(File folder) {
        this.recentlyUsedFolderPaths.put(folder.getAbsolutePath(), System.currentTimeMillis());
    }

    private static String kbLockName(String projectKey, String knowledgeBankId) {
        return String.format("dku.knowledge-bank.%s-%s", projectKey, knowledgeBankId);
    }

    private static String kbVersionLockName(String projectKey, String knowledgeBankId, String version) {
        return String.format("dku.knowledge-bank.%s-%s-%s", projectKey, knowledgeBankId, version);
    }

    public String getCurrentlyUsedVersion(RetrievableKnowledge kb) throws IOException {
        String lockName = KnowledgeBankManagementService.kbLockName(kb.getProjectKey(), kb.getId());
        try (AutoCloseableLock lock = NamedRWLock.acquireRead((String)lockName);){
            String currentVersion = RetrievableKnowledgeUtils.getCurrentVersionUnsafe(kb);
            if ("not-built".equals(currentVersion)) {
                String string = "not-built";
                return string;
            }
            File kbFolder = RetrievableKnowledgeUtils.getVersionFolder(kb, currentVersion);
            this.markAsRecentlyUsed(kbFolder);
            String string = currentVersion;
            return string;
        }
    }

    public <E extends Exception> void readKnowledgeBankFolder(RetrievableKnowledge kb, String version, ExceptionUtils.ThrowingConsumer<File, E> consumer) throws E {
        String lockName = KnowledgeBankManagementService.kbVersionLockName(kb.getProjectKey(), kb.getId(), version);
        try (AutoCloseableLock lock = NamedRWLock.acquireRead((String)lockName);){
            File folder = RetrievableKnowledgeUtils.getVersionFolder(kb, version);
            consumer.accept((Object)folder);
        }
    }

    public <E extends Exception> void writeKnowledgeBankFolder(RetrievableKnowledge kb, String version, ExceptionUtils.ThrowingConsumer<File, E> consumer) throws E {
        String lockName = KnowledgeBankManagementService.kbVersionLockName(kb.getProjectKey(), kb.getId(), version);
        try (AutoCloseableLock lock = NamedRWLock.acquireWrite((String)lockName);){
            File folder = RetrievableKnowledgeUtils.getVersionFolder(kb, version);
            consumer.accept((Object)folder);
        }
    }

    @PostConstruct
    public void schedulePeriodicCleanup() throws IOException {
        int cleanupPeriod = DKUApp.getParams().getIntParam("dku.llm.retrieval.outdated.cleanupPeriodInMinutes", Integer.valueOf(2));
        logger.infoV("Scheduling periodic cleanup of outdated knowledge banks every %d minutes, starting in %d minutes", new Object[]{cleanupPeriod, cleanupPeriod});
        this.executor.scheduleWithFixedDelay(this::clean, cleanupPeriod, cleanupPeriod, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void shutdownExecutor() {
        this.executor.shutdownNow();
    }

    @VisibleForTesting
    void clean() {
        File baseFolder = DKUApp.getFile((String)"knowledge-banks");
        if (!baseFolder.exists() || !baseFolder.isDirectory()) {
            return;
        }
        File[] projectFolders = baseFolder.listFiles(File::isDirectory);
        if (projectFolders == null) {
            return;
        }
        for (File projectFolder : projectFolders) {
            try {
                this.cleanProject(projectFolder);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Cannot clean outdated knowledge banks for project: %s", projectFolder.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void cleanProject(File projectFolder) {
        String projectKey = projectFolder.getName();
        File[] kbFolders = projectFolder.listFiles(File::isDirectory);
        if (kbFolders == null) {
            return;
        }
        for (File kbFolder : kbFolders) {
            String lockName = KnowledgeBankManagementService.kbLockName(projectKey, kbFolder.getName());
            try (AutoCloseableLock lock = NamedRWLock.acquireWrite((String)lockName);){
                this.cleanKnowledgeBank(projectKey, kbFolder);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Cannot clean outdated knowledge bank versions: %s", kbFolder.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void cleanKnowledgeBank(String projectKey, File kbFolder) {
        RetrievableKnowledge.RetrievableKnowledgeVersions metadata;
        File versionsFolder = DKUApp.getFile((File)kbFolder, (String[])new String[]{"versions"});
        if (!versionsFolder.exists() || !versionsFolder.isDirectory()) {
            return;
        }
        File versionsFile = DKUApp.getFile((File)kbFolder, (String[])new String[]{"versions.json"});
        if (!versionsFile.exists()) {
            return;
        }
        try {
            metadata = (RetrievableKnowledge.RetrievableKnowledgeVersions)JSON.parseFile((File)versionsFile, RetrievableKnowledge.RetrievableKnowledgeVersions.class);
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Cannot parse JSON file %s", versionsFile.getAbsolutePath()), (Throwable)e);
            return;
        }
        if (StringUtils.isBlank((CharSequence)metadata.currentVersion)) {
            logger.warn((Object)String.format("Versions file has no current version: %s", versionsFile.getAbsolutePath()));
            return;
        }
        String knowledgeBankId = kbFolder.getName();
        String lockName = KnowledgeBankManagementService.kbVersionLockName(projectKey, knowledgeBankId, "not-versioned");
        try (NamedRWLock.WriteLockHandle lock = NamedRWLock.tryAcquireWrite((String)lockName);){
            if (lock.isAcquired()) {
                this.cleanNotVersionedFiles(kbFolder);
            }
        }
        if (Objects.equals(SINGLE_VERSION, metadata.currentVersion)) {
            return;
        }
        long currentVersionTime = Long.parseLong(metadata.currentVersion);
        File[] versionFolders = versionsFolder.listFiles(File::isDirectory);
        if (versionFolders == null) {
            return;
        }
        for (File folder : versionFolders) {
            String version = folder.getName();
            if (Objects.equals(metadata.currentVersion, version)) continue;
            lockName = KnowledgeBankManagementService.kbVersionLockName(projectKey, knowledgeBankId, version);
            try (NamedRWLock.WriteLockHandle lock = NamedRWLock.tryAcquireWrite((String)lockName);){
                if (!lock.isAcquired()) continue;
                this.cleanVersionedFolderIfOutdated(folder, currentVersionTime);
            }
        }
    }

    private void cleanNotVersionedFiles(File kbFolder) {
        File[] files = kbFolder.listFiles();
        if (files == null) {
            return;
        }
        if (this.isRecentlyUsed(kbFolder)) {
            return;
        }
        for (File file : files) {
            if (Objects.equals(file.getName(), "versions") || Objects.equals(file.getName(), "versions.json")) continue;
            logger.info((Object)String.format("Delete old knowledge bank file: %s", file.getAbsolutePath()));
            try {
                if (file.isDirectory()) {
                    DKUFileUtils.deleteDirectory((File)file);
                    continue;
                }
                DKUFileUtils.delete((File)file);
            }
            catch (IOException e) {
                logger.error((Object)String.format("Cannot delete old knowledge bank file: %s", file.getAbsolutePath()), (Throwable)e);
            }
        }
        this.recentlyUsedFolderPaths.remove(kbFolder.getAbsolutePath());
    }

    private void cleanVersionedFolderIfOutdated(File folder, long currentVersionTime) {
        try {
            boolean clean;
            String version = folder.getName();
            if (this.isRecentlyUsed(folder)) {
                clean = false;
            } else if (SINGLE_VERSION.equals(version)) {
                clean = true;
            } else {
                long versionTime = Long.parseLong(version);
                boolean bl = clean = versionTime < currentVersionTime;
            }
            if (clean) {
                logger.info((Object)String.format("Delete old knowledge bank folder: %s", folder.getAbsolutePath()));
                DKUFileUtils.deleteDirectory((File)folder);
                this.recentlyUsedFolderPaths.remove(folder.getAbsolutePath());
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Cannot delete old knowledge bank folder: %s", folder.getAbsolutePath()), (Throwable)e);
        }
    }

    private boolean isRecentlyUsed(File folder) {
        Long lastUsed = this.recentlyUsedFolderPaths.get(folder.getAbsolutePath());
        if (lastUsed == null) {
            return false;
        }
        long delay = DKUApp.getParams().getLongParam("dku.llm.retrieval.outdated.cleanAfterDelayInSeconds", 600L);
        long now = System.currentTimeMillis();
        return now - lastUsed < delay * 1000L;
    }
}

