/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class RetrievableKnowledgeUtils {
    public static final String VERSIONS_FOLDER_NAME = "versions";
    public static final String VERSIONS_FILE_NAME = "versions.json";
    public static final String NOT_VERSIONED = "not-versioned";
    public static final String NOT_BUILT = "not-built";
    public static final String KB_CONNECTION_INFO_ENV = "DKU_KB_CONNECTION_INFO";

    public static String getCurrentVersionUnsafe(RetrievableKnowledge kb) throws IOException {
        File kbFolder = RetrievableKnowledgeUtils.getDataFolder(kb.getProjectKey(), kb.getId());
        if (!kbFolder.exists()) {
            return NOT_BUILT;
        }
        File versionsFile = DKUApp.getFile((File)kbFolder, (String[])new String[]{VERSIONS_FILE_NAME});
        if (!versionsFile.exists()) {
            return NOT_VERSIONED;
        }
        RetrievableKnowledge.RetrievableKnowledgeVersions metadata = (RetrievableKnowledge.RetrievableKnowledgeVersions)JSON.parseFile((File)versionsFile, RetrievableKnowledge.RetrievableKnowledgeVersions.class);
        File versionFolder = DKUApp.getFile((File)kbFolder, (String[])new String[]{VERSIONS_FOLDER_NAME, metadata.currentVersion});
        if (!versionFolder.exists()) {
            throw new IOException(String.format("Knowledge bank current version '%s' does not exist", metadata.currentVersion));
        }
        return versionFolder.getName();
    }

    public static File getDataFolder(String projectKey, String id) {
        return DKUApp.getFile((String[])new String[]{"knowledge-banks", projectKey, id});
    }

    public static File getVersionFolder(RetrievableKnowledge kb, String version) {
        File kbFolder = RetrievableKnowledgeUtils.getDataFolder(kb.getProjectKey(), kb.getId());
        return Set.of(NOT_BUILT, NOT_VERSIONED).contains(version) ? kbFolder : DKUApp.getFile((File)kbFolder, (String[])new String[]{VERSIONS_FOLDER_NAME, version});
    }

    private static void checkAccess(AuthCtx authCtx, String contextProjectKey, TaggableObjectsService.TaggableObject taggableObject) throws IOException, DKUSecurityException {
        switch (ClusterSelector.getContext()) {
            case BACKEND: {
                ((ProjectsService)SpringUtils.getBean(ProjectsService.class)).failIfNoReadAccess(authCtx, taggableObject.getRef(), contextProjectKey);
                return;
            }
            case JEK: {
                APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
                     TicketBasedIntercomAPIClient apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());){
                    apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-taggable-object-read-use-privilege", Void.class, new Object[]{"taggableObjectRef", taggableObject.getRef(), "contextProjectKey", contextProjectKey});
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Failed to check access to " + String.valueOf((Object)taggableObject.getTaggableType()) + " " + String.valueOf(taggableObject.getRef()), (Throwable)e);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Cannot check access of object " + String.valueOf((Object)taggableObject.getTaggableType()) + " on process " + String.valueOf(ClusterSelector.getContext()));
    }

    private static void checkTaggableObjectAvailableInProject(TaggableObjectsService.TaggableObject taggableObject, String contextProjectKey) throws IOException, DKUSecurityException {
        switch (ClusterSelector.getContext()) {
            case BACKEND: {
                ((ProjectsService)SpringUtils.getBean(ProjectsService.class)).failIfLocNotAvailableInProject(taggableObject.getTaggableType(), taggableObject.getRef().getLoc(), contextProjectKey);
                return;
            }
            case JEK: {
                APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
                     TicketBasedIntercomAPIClient apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());){
                    apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-taggable-object-available-in-project", Void.class, new Object[]{"taggableObjectRef", taggableObject.getRef(), "contextProjectKey", contextProjectKey});
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Failed to check object available in project " + String.valueOf((Object)taggableObject.getTaggableType()) + " " + String.valueOf(taggableObject.getRef()), (Throwable)e);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Cannot check object available in project " + String.valueOf((Object)taggableObject.getTaggableType()) + " on process " + String.valueOf(ClusterSelector.getContext()));
    }

    public static RetrievableKnowledge getValidRK(AuthCtx authCtx, String contextProjectKey, SavedModel sm, SavedModel.SavedModelInlineVersion smiv) throws DKUSecurityException, IOException {
        RetrievableKnowledge rk;
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction ignored = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
            RetrievableKnowledgeUtils.checkAccess(authCtx, contextProjectKey, sm);
            AnyLoc locRK = AnyLoc.resolveSmart(sm.projectKey, smiv.ragllmSettings.kbRef);
            rk = (RetrievableKnowledge)((RetrievableKnowledgeDAO)SpringUtils.getBean(RetrievableKnowledgeDAO.class)).getMandatory(locRK);
            RetrievableKnowledgeUtils.checkTaggableObjectAvailableInProject(rk, sm.projectKey);
        }
        return rk;
    }
}

