/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.PythonMetricKernel;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.PythonCheck;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractPythonCheck
extends Check {
    private static Logger logger = Logger.getLogger((String)"dku.datasets.checks.python");

    protected abstract String getCode() throws IOException;

    protected abstract PluginSettingsResolver.ResolvedSettings getPluginConfig(AuthCtx var1, String var2) throws IOException, DKUSecurityException;

    protected abstract String getResourceFolder();

    protected abstract String getLibFolder();

    protected abstract String getEnvName(String var1) throws IOException;

    public AbstractCheckContext.CheckResult doRun(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        PythonMetricKernel kernel = null;
        SingleCommandKernelLink link = null;
        try {
            AbstractCheckContext.CheckResult checkResult;
            block25: {
                AutoDelete tmpDir = FlowJobUtils.getTmpFolder("python-check", "run");
                try {
                    String secret = SecretKeyGenerator.generate((int)16);
                    PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
                    link = new SingleCommandKernelLink(secret, dssPortRange);
                    String envName = this.getEnvName(context.projectKey);
                    kernel = new PythonMetricKernel(link, context.getTicket(), this.getResourceFolder(), this.getLibFolder(), (File)tmpDir, context.projectKey, authCtx, envName);
                    kernel.start();
                    context.ensureLastValues();
                    AbstractCheckContext.CheckParameters checkParams = context.setParamsForPythonChecks();
                    PluginSettingsResolver.ResolvedSettings resolvedSettings = this.getPluginConfig(authCtx, context.projectKey);
                    PythonMetricKernel.RunCheckRequest req = new PythonMetricKernel.RunCheckRequest(this.getCode(), resolvedSettings.config, resolvedSettings.pluginConfig, checkParams.objectType, checkParams.fullName, checkParams.partitionId, context.getLastValues());
                    PythonMetricKernel.RunCheckResponse resp = (PythonMetricKernel.RunCheckResponse)link.execute((Object)req, PythonMetricKernel.RunCheckResponse.class, "Exception raised while computing check");
                    logger.info((Object)("Kernel answered outcome " + String.valueOf((Object)resp.outcome)));
                    logger.info((Object)("Kernel answered message " + resp.message));
                    checkResult = new AbstractCheckContext.CheckResult(resp.outcome == null ? AbstractCheckContext.CheckOutcome.EMPTY : resp.outcome, resp.message);
                    if (tmpDir == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (tmpDir != null) {
                            try {
                                tmpDir.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SocketBlockLinkException e) {
                        e.withLogTail(kernel);
                        throw kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
                    }
                    catch (SocketBlockLink.SecretKernelTimeoutException e) {
                        logger.error((Object)"Failure during kernel startup", (Throwable)e);
                        throw new CustomPythonKernelException("Failure during kernel startup", (Exception)((Object)e), kernel.getLogTail());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Generic failure during check computation", (Throwable)e);
                        throw new CustomPythonKernelException("Failure during check computation", e, kernel.getLogTail());
                    }
                }
                tmpDir.close();
            }
            return checkResult;
        }
        finally {
            if (kernel != null) {
                try {
                    kernel.killWithoutMercy();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to kill kernel", e);
                }
            }
            if (link != null) {
                try {
                    link.close();
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to close link", e);
                }
            }
        }
    }

    @PolyJSON(value={@Mapping(value=PythonCheck.class, type="python")})
    public static abstract class AbstractPolyJsonablePythonCheck
    extends AbstractPythonCheck {
    }
}

