/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.pivot.backend.dss.aggregators.DoubleAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import java.util.function.BiFunction;

public class BiFuncAggregator
extends DoubleAggregator {
    private static final String ERROR_MESSAGE = "Cannot min/max non numeric values.";
    BiFunction<Double, Double, Double> biFunction;
    private Double fillValue;

    public BiFuncAggregator(Aggregation req, BiFunction<Double, Double, Double> biFunction, Double fillValue) {
        super(req, ERROR_MESSAGE);
        this.init(biFunction, fillValue);
    }

    public BiFuncAggregator(Aggregation req, int bins, BiFunction<Double, Double, Double> biFunction, Double fillValue) {
        super(req, bins, ERROR_MESSAGE);
        this.init(biFunction, fillValue);
    }

    public BiFuncAggregator(Aggregation req, int[] numBins, BiFunction<Double, Double, Double> biFunction, Double fillValue) {
        super(req, numBins, ERROR_MESSAGE);
        this.init(biFunction, fillValue);
    }

    private void init(BiFunction<Double, Double, Double> biFunction, Double fillValue) {
        this.biFunction = biFunction;
        this.fillValue = fillValue;
        this.getOutDT().initDoubleTensor(fillValue);
    }

    @Override
    public void initMerge(int[] axisLengths) {
        super.initMerge(axisLengths);
        this.getMergeDT().initDoubleTensor(this.fillValue);
    }

    @Override
    public double mergeDoubleValues(double a, double b) {
        return this.biFunction.apply(a, b);
    }
}

