/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.binners;

import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.EmptyCustomBinsException;
import com.dataiku.dip.pivot.backend.model.NumericalAxisElt;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.sql.binners.LongAxisBinner;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.utils.BinUtils;
import com.dataiku.dip.pivot.backend.sql.utils.NullableLongArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BinnedNumericalAxisBinner
implements LongAxisBinner {
    private long maxVal;
    private long minVal;
    private final List<AxisElt> elts = new ArrayList<AxisElt>();
    private final HashMap<Long, Integer> map = new HashMap();
    private boolean natural;
    private NumericalAxisElt allBin;

    public BinnedNumericalAxisBinner(NullableLongArrayList values, AxisDef def, BasicStatsBuilder.BasicStats stats, boolean natural, boolean generateTotalBin) {
        if (values.isEmpty()) {
            return;
        }
        if (def.numParams.mode.equals((Object)NumericalAxisParams.BinningMode.CUSTOM)) {
            this.natural = true;
            BasicStatsBuilder.ColStats colStats = stats.columnStats.get(def.column);
            this.elts.addAll(PivotUtils.getCustomBinsAxisElts(PivotUtils.getValidatedCustomBins(def), colStats.minValue, colStats.maxValue));
            return;
        }
        this.natural = natural;
        if (natural) {
            this.minVal = values.min();
            this.maxVal = values.max();
            int cnt = 0;
            for (long i = this.minVal; i <= this.maxVal; ++i) {
                AxisElt elt = BinnedNumericalAxisBinner.createNumericalBin(def, stats, i);
                elt.binIndex = cnt++;
                this.elts.add(elt);
            }
        } else {
            int i = 0;
            while (i < values.size()) {
                long val = values.get(i);
                this.map.put(val, i);
                AxisElt elt = BinnedNumericalAxisBinner.createNumericalBin(def, stats, val);
                elt.binIndex = i++;
                this.elts.add(elt);
            }
        }
        if (generateTotalBin) {
            this.allBin = new NumericalAxisElt();
            this.allBin.max = Double.MAX_VALUE;
            this.allBin.min = Double.MIN_VALUE;
            this.allBin.sortValue = Double.MAX_VALUE;
            this.allBin.binIndex = this.elts.size();
            this.allBin.label = "___dku_total_value___";
            this.elts.add(this.allBin);
        }
    }

    @Override
    public int assign(Long val) {
        if (val == null) {
            return this.allBin.binIndex;
        }
        if (this.natural) {
            return (int)(val - this.minVal);
        }
        return this.map.get(val);
    }

    private static AxisElt createNumericalBin(AxisDef def, BasicStatsBuilder.BasicStats stats, long binVal) {
        if (def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB) {
            BasicStatsBuilder.ColStats minmax = stats.columnStats.get(def.column);
            BinUtils.HistogramParams histogramParams = BinUtils.getHistogramParams(def.numParams.niceBounds, def.numParams.nbBins, minmax.minValue, minmax.maxValue);
            return BinnedNumericalAxisBinner.createFixedNbNumericalBin(histogramParams, binVal);
        }
        if (def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_SIZE) {
            return BinnedNumericalAxisBinner.createFixedSizeNumericalBin(def, binVal);
        }
        if (def.numParams.mode == NumericalAxisParams.BinningMode.CUSTOM) {
            return BinnedNumericalAxisBinner.createCustomNumericalBins(def, binVal);
        }
        throw new RuntimeException("Cannot handle non binned axis here");
    }

    private static AxisElt createFixedNbNumericalBin(BinUtils.HistogramParams histogramParams, long binVal) {
        NumericalAxisElt elt = new NumericalAxisElt();
        double start = (double)binVal * histogramParams.step + histogramParams.fixedMin;
        double end = (double)(binVal + 1L) * histogramParams.step + histogramParams.fixedMin;
        BinnedNumericalAxisBinner.fillAxisElt(elt, start, end);
        return elt;
    }

    private static AxisElt createFixedSizeNumericalBin(AxisDef def, long binVal) {
        NumericalAxisElt elt = new NumericalAxisElt();
        double start = (double)binVal * def.numParams.binSize;
        double end = (double)(binVal + 1L) * def.numParams.binSize;
        BinnedNumericalAxisBinner.fillAxisElt(elt, start, end);
        return elt;
    }

    private static AxisElt createCustomNumericalBins(AxisDef def, long binVal) {
        double end;
        double start;
        NumericalAxisElt elt = new NumericalAxisElt();
        int index = (int)binVal;
        List<Double> customBins = def.numParams.customBinValues;
        if (customBins == null || customBins.isEmpty()) {
            throw new EmptyCustomBinsException("Please add some custom bins to your dimension.");
        }
        if (index == 0) {
            start = Double.NEGATIVE_INFINITY;
            end = customBins.get(0);
        } else if (index == customBins.size()) {
            start = customBins.get(customBins.size() - 1);
            end = Double.POSITIVE_INFINITY;
        } else {
            start = customBins.get(index - 1);
            end = customBins.get(index);
        }
        BinnedNumericalAxisBinner.fillAxisElt(elt, start, end);
        return elt;
    }

    private static void fillAxisElt(NumericalAxisElt elt, double start, double end) {
        elt.max = end;
        elt.min = start;
        elt.label = start + " - " + end;
        elt.sortValue = (start + end) / 2.0;
    }

    @Override
    public AxisElt getOtherBin() {
        return null;
    }

    @Override
    public List<AxisElt> getAxisElts() {
        return this.elts;
    }
}

