/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.builders;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.BinningToSQL;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.utils.DKULogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class FacetBuilder {
    private final RowFilter rf;
    private final int index;
    private static final DKULogger logger = DKULogger.getLogger(FacetBuilder.class);

    public FacetBuilder(int index, RowFilter rf) {
        this.index = index;
        this.rf = rf;
    }

    public FilterFacet fromResultSet(ResultSet rs2, BasicStatsBuilder.ColStats colStats) throws SQLException {
        FilterFacet ff = new FilterFacet();
        ff.filterIdx = this.index;
        ff.isAGlobalFilter = this.rf.isAGlobalFilter;
        switch (this.rf.columnType) {
            case ALPHANUM: {
                return this.buildAlphanum(ff, rs2);
            }
            case DATE: {
                return this.buildDate(ff, rs2, colStats);
            }
            case NUMERICAL: {
                return this.buildNumerical(ff, rs2, colStats);
            }
        }
        throw new UnsupportedOperation("Unsupported column type");
    }

    private FilterFacet buildDate(FilterFacet ff, ResultSet rs2, BasicStatsBuilder.ColStats colStats) throws SQLException {
        if (this.rf.dateFilterType == ChartFilter.DateFilterType.RANGE) {
            this.buildNumerical(ff, rs2, colStats);
            ff.globalMinValue *= 1000.0;
            ff.globalMaxValue *= 1000.0;
            ff.minValue *= 1000.0;
            ff.maxValue *= 1000.0;
            return ff;
        }
        FacetBuilder.addGlobalMinAndMax(ff, colStats);
        ff.globalMinValue *= 1000.0;
        ff.globalMaxValue *= 1000.0;
        if (this.rf.dateFilterType == ChartFilter.DateFilterType.RELATIVE) {
            if (rs2.next()) {
                ff.maxValue = 1.0;
                ff.minValue = 1.0;
                ff.option = new ChartFilter.DateRelativeOption();
                ff.part = ChartFilter.DateFilterPart.YEAR;
            }
        } else {
            IDateBinner dateBinner = BinningToSQL.toBinningMode(this.rf.dateFilterType, this.rf.dateFilterPart).getDateBinner();
            while (rs2.next()) {
                long val = rs2.getLong(1);
                boolean wasNull = rs2.wasNull();
                long count = rs2.getLong(2);
                if (!wasNull) {
                    ff.totalNbValues = (int)((long)ff.totalNbValues + count);
                    long binId = dateBinner.getBinIdFromSqlValue(val);
                    ff.values.add(new FilterFacet.Val("" + binId, dateBinner.getLabel(binId), count));
                    continue;
                }
                ff.values.add(new FilterFacet.Val("___dku_no_value___", "No value", count));
            }
        }
        return ff;
    }

    private FilterFacet buildNumerical(FilterFacet ff, ResultSet rs2, BasicStatsBuilder.ColStats colStats) throws SQLException {
        if (ChartFilter.FilterType.ALPHANUM_FACET.equals((Object)this.rf.filterType)) {
            return this.buildAlphanum(ff, rs2);
        }
        if (rs2.next()) {
            FacetBuilder.addGlobalMinAndMax(ff, colStats);
            ff.minValue = rs2.getDouble(1);
            if (rs2.wasNull()) {
                ff.minValue = ff.globalMinValue;
            }
            ff.maxValue = rs2.getDouble(2);
            if (rs2.wasNull()) {
                ff.maxValue = ff.globalMaxValue;
            }
        }
        return ff;
    }

    private static void addGlobalMinAndMax(FilterFacet ff, BasicStatsBuilder.ColStats colStats) {
        if (colStats != null) {
            ff.globalMinValue = colStats.minValue;
            ff.globalMaxValue = colStats.maxValue;
            ff.count = colStats.approxCount;
        }
    }

    private FilterFacet buildAlphanum(FilterFacet ff, ResultSet rs2) throws SQLException {
        long facetsSafetyThreshold = FilterUtils.getAlphanumFacetsSafetyThreshold();
        while (rs2.next()) {
            String val;
            long count = rs2.getLong(2);
            String label = val = rs2.getString(1);
            if (StringUtils.isBlank((String)val) || "___dku_no_value___".equals(val)) {
                label = "No value";
                val = "___dku_no_value___";
            }
            ff.totalNbValues = (int)((long)ff.totalNbValues + count);
            ff.values.add(new FilterFacet.Val(val, label, count));
            if ((long)ff.values.size() < facetsSafetyThreshold) continue;
            ff.isTruncated = true;
            logger.error((Object)("Truncated alpha-numerical facet on column \"" + this.rf.column + "\" (too many values: > " + facetsSafetyThreshold + ")"));
            break;
        }
        return ff;
    }
}

