/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.color;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Color {
    public final double r;
    public final double g;
    public final double b;
    public final double a;
    public static final String darkHexColor = "#333333";
    public static final String lightHexColor = "#FFFFFF";
    public static final Color darkColor = Color.fromHTML("#333333");
    public static final Color lightColor = Color.fromHTML("#FFFFFF");
    public static final double darkColorLuminance = Color.getLuminance(darkColor);
    public static final double lightColorLuminance = Color.getLuminance(lightColor);
    private static Pattern rgbColorPattern = Pattern.compile("rgb\\(([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3})\\)");

    private Color(double r, double g, double b, double a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    private Color(double r, double g, double b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0;
    }

    public static Color mix(Color colorA, Color colorB, double ratioA) {
        ratioA = Math.min(Math.max(0.0, ratioA), 1.0);
        double ratioB = 1.0 - ratioA;
        return Color.fromRGB(colorA.r * ratioA + colorB.r * ratioB, colorA.g * ratioA + colorB.g * ratioB, colorA.b * ratioA + colorB.b * ratioB);
    }

    public static Color fromRGB(double r, double g, double b) {
        r = Math.min(Math.max(0.0, r), 255.0);
        g = Math.min(Math.max(0.0, g), 255.0);
        b = Math.min(Math.max(0.0, b), 255.0);
        return new Color(r, g, b, 1.0);
    }

    public static Color fromRGBA(double r, double g, double b, double a) {
        r = Math.min(Math.max(0.0, r), 255.0);
        g = Math.min(Math.max(0.0, g), 255.0);
        b = Math.min(Math.max(0.0, b), 255.0);
        a = Math.min(Math.max(0.0, a), 1.0);
        return new Color(r, g, b, a);
    }

    public static Color fromHTML(String hex) {
        Matcher matcher;
        if (hex.startsWith("#")) {
            int r = hex.length() > 2 ? Integer.valueOf(hex.substring(1, 3), 16) : 0;
            int g = hex.length() > 4 ? Integer.valueOf(hex.substring(3, 5), 16) : 0;
            int b = hex.length() > 6 ? Integer.valueOf(hex.substring(5, 7), 16) : 0;
            return Color.fromRGB(r, g, b);
        }
        if (hex.startsWith("rgb(") && (matcher = rgbColorPattern.matcher(hex)).find()) {
            return Color.fromRGB(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
        }
        throw new RuntimeException("Invalid color: " + hex);
    }

    public static Color fromString(String color) {
        String[] colorParts;
        if (color.startsWith("#") && color.length() == 7) {
            int r = Integer.parseInt(color.substring(1, 3), 16);
            int g = Integer.parseInt(color.substring(3, 5), 16);
            int b = Integer.parseInt(color.substring(5, 7), 16);
            return Color.fromRGB(r, g, b);
        }
        int indexBeg = color.indexOf("(");
        int indexEnd = color.lastIndexOf(")");
        if (indexBeg != -1 && indexEnd != -1 && (colorParts = color.substring(indexBeg + 1, indexEnd).split(",")).length >= 3) {
            double r = Double.parseDouble(colorParts[0]);
            double g = Double.parseDouble(colorParts[1]);
            double b = Double.parseDouble(colorParts[2]);
            double a = 1.0;
            if (colorParts.length > 3) {
                a = Double.parseDouble(colorParts[3]);
            }
            return Color.fromRGBA(r, g, b, a);
        }
        throw new RuntimeException("Invalid color: " + color);
    }

    public static String getFontContrastColor(String color) {
        double darkContrastRatio;
        if (color == null) {
            return lightHexColor;
        }
        Color colorRgba = Color.fromString(color);
        double colorRgbaLuminance = Color.getLuminance(colorRgba) + 0.05;
        double lightContrastRatio = (lightColorLuminance + 0.05) / colorRgbaLuminance;
        return lightContrastRatio < (darkContrastRatio = colorRgbaLuminance / (darkColorLuminance + 0.05)) ? darkHexColor : lightHexColor;
    }

    public static double getLuminance(Color colorRgba) {
        DoubleUnaryOperator sRGB = c2 -> {
            double XsRGB = c2 / 255.0;
            if (XsRGB <= 0.03928) {
                return XsRGB;
            }
            return Math.pow((XsRGB + 0.055) / 1.055, 2.4);
        };
        DoubleBinaryOperator blendWithWhite = (channel, alpha) -> (1.0 - alpha) * 255.0 + alpha * channel;
        double r = blendWithWhite.applyAsDouble(colorRgba.r, colorRgba.a);
        double g = blendWithWhite.applyAsDouble(colorRgba.g, colorRgba.a);
        double b = blendWithWhite.applyAsDouble(colorRgba.b, colorRgba.a);
        double luminance = 0.2126 * sRGB.applyAsDouble(r) + 0.7152 * sRGB.applyAsDouble(g) + 0.0722 * sRGB.applyAsDouble(b);
        return (double)Math.round(luminance * 1000.0) / 1000.0;
    }

    public static String getLerpRGB(String color1, String color2, double t) {
        Color colorRgba1 = Color.fromString(color1);
        Color colorRgba2 = Color.fromString(color2);
        t = Math.min(Math.max(0.0, t), 1.0);
        int r = (int)Math.round(colorRgba1.r + (colorRgba2.r - colorRgba1.r) * t);
        int g = (int)Math.round(colorRgba1.g + (colorRgba2.g - colorRgba1.g) * t);
        int b = (int)Math.round(colorRgba1.b + (colorRgba2.b - colorRgba1.b) * t);
        double a = colorRgba1.a + (colorRgba2.a - colorRgba1.a) * t;
        if (a < 1.0) {
            return String.format("rgba(%d,%d,%d,%.2f)", r, g, b, a);
        }
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public byte[] asByteArray() {
        return new byte[]{(byte)this.r, (byte)this.g, (byte)this.b};
    }

    public String toHtml() {
        return String.format("#%02X%02X%02X", (int)this.r, (int)this.g, (int)this.b);
    }

    public static double[] rgbToHsl(Color color) {
        double s;
        double h;
        double rNorm = color.r / 255.0;
        double gNorm = color.g / 255.0;
        double bNorm = color.b / 255.0;
        double max = Math.max(rNorm, Math.max(gNorm, bNorm));
        double min = Math.min(rNorm, Math.min(gNorm, bNorm));
        double delta = max - min;
        double l = (max + min) / 2.0;
        if (delta == 0.0) {
            h = 0.0;
            s = 0.0;
        } else {
            h = max == rNorm ? (60.0 * (gNorm - bNorm) / delta + 360.0) % 360.0 : (max == gNorm ? 60.0 * (bNorm - rNorm) / delta + 120.0 : 60.0 * (rNorm - gNorm) / delta + 240.0);
            s = l <= 0.5 ? delta / (max + min) : delta / (2.0 - delta);
        }
        return new double[]{h, s * 100.0, l};
    }

    public static Color hslToRGB(double h, double s, double l) {
        if (s < 0.0 || s > 100.0) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l < 0.0 || l > 100.0) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        double q = l < 0.5 ? l * (1.0 + s) : l + (s /= 100.0) - s * l;
        double p = 2.0 * l - q;
        double r = Math.max(0.0, Color.hueToRGB(p, q, (h /= 360.0) + 0.3333333333333333));
        double g = Math.max(0.0, Color.hueToRGB(p, q, h));
        double b = Math.max(0.0, Color.hueToRGB(p, q, h - 0.3333333333333333));
        r = Math.min(r, 1.0) * 255.0;
        g = Math.min(g, 1.0) * 255.0;
        b = Math.min(b, 1.0) * 255.0;
        return new Color(r, g, b);
    }

    private static double hueToRGB(double p, double q, double h) {
        if (h < 0.0) {
            h += 1.0;
        }
        if (h > 1.0) {
            h -= 1.0;
        }
        if (6.0 * h < 1.0) {
            return p + (q - p) * 6.0 * h;
        }
        if (2.0 * h < 1.0) {
            return q;
        }
        if (3.0 * h < 2.0) {
            return p + (q - p) * 6.0 * (0.6666666865348816 - h);
        }
        return p;
    }

    public static String brighten(BrightenParams params) {
        Color color = Color.fromHTML(params.color);
        double[] hsl = Color.rgbToHsl(color);
        double d = hsl[2] == 0.0 ? (double)0.15f : hsl[2];
        hsl[2] = Math.min(d * (double)params.k, (double)params.maxLuminance);
        Color brightenedColor = Color.hslToRGB(hsl[0], hsl[1], hsl[2]);
        return String.format("#%02X%02X%02X", (int)brightenedColor.r, (int)brightenedColor.g, (int)brightenedColor.b);
    }

    public static String darken(DarkenParams params) {
        Color color = Color.fromHTML(params.color);
        double[] hsl = Color.rgbToHsl(color);
        hsl[2] = Math.max(hsl[2] - (double)(params.k - 1.0f) * hsl[2], (double)params.minLuminance);
        Color darkenedColor = Color.hslToRGB(hsl[0], hsl[1], hsl[2]);
        return String.format("#%02X%02X%02X", (int)darkenedColor.r, (int)darkenedColor.g, (int)darkenedColor.b);
    }

    public static class BrightenParams {
        public final String color;
        final float k;
        final float maxLuminance;
        static final float defaultMaxLuminance = 1.0f;
        static final float defaultK = 1.3f;

        public BrightenParams(String color, float k, float maxLuminance) {
            this.color = color;
            this.k = k;
            this.maxLuminance = maxLuminance;
        }

        public BrightenParams(String colors, float k) {
            this(colors, k, 1.0f);
        }

        public BrightenParams(String colors) {
            this(colors, 1.3f, 1.0f);
        }
    }

    public static class DarkenParams {
        public final String color;
        final float k;
        final float minLuminance;
        static final float defaultMinLuminance = 0.15f;
        static final float defaultK = 1.3f;

        public DarkenParams(String color, float k, float minLuminance) {
            this.color = color;
            this.k = k;
            this.minLuminance = minLuminance;
        }

        public DarkenParams(String colors, float k) {
            this(colors, k, 0.15f);
        }

        public DarkenParams(String colors) {
            this(colors, 1.3f, 0.15f);
        }
    }
}

