/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.excel.BaseDataSheetBuilder;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;

public abstract class BaseDataSheet2DBuilder
extends BaseDataSheetBuilder {
    protected static void fill(XSSFSheet sheet, PivotTableTensorResponse response, CellStyler styler, CellStyle headerStyle, int animationFrameIdx) {
        int[] coords;
        for (int y = 0; y < response.axisLabels[1].size(); ++y) {
            AxisElt yLabel = response.axisLabels[1].get(y);
            String label = ChartUtils.labelify(yLabel.label);
            SheetUtils.writeCell(sheet, 2, 1 + y, label).setCellStyle(headerStyle);
        }
        if (animationFrameIdx < 0) {
            coords = new int[2];
        } else {
            coords = new int[3];
            coords[2] = animationFrameIdx;
        }
        for (int x = 0; x < response.axisLabels[0].size(); ++x) {
            coords[0] = x;
            AxisElt xLabel = response.axisLabels[0].get(x);
            String label = ChartUtils.labelify(xLabel.label);
            CellStyle axisStyle = styler.getValueStyle(x == response.axisLabels[0].size() - 1, true);
            SheetUtils.writeCell(sheet, 3 + x, 0, label).setCellStyle(axisStyle);
            for (int y = 0; y < response.axisLabels[1].size(); ++y) {
                coords[1] = y;
                CellStyle style = styler.getValueStyle(x == response.axisLabels[0].size() - 1, false);
                SheetUtils.writeCell(sheet, 3 + x, 1 + y, ((DataTensor)response.aggregations.get(0)).getAsDouble(coords)).setCellStyle(style);
            }
        }
    }
}

