/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.plugins.FileBasedPluginSettingsDAO;
import com.dataiku.dip.plugins.IPluginSettingsDAO;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginConfigUtils;
import com.dataiku.dip.plugins.exceptions.DuplicatePluginException;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class RegularPluginsRegistryService
implements IPluginsRegistryService {
    private static File baseDir = ApplicationConfigurator.getFile((String[])new String[]{"plugins", "installed"});
    private static File baseDevDir = ApplicationConfigurator.getFile((String[])new String[]{"plugins", "dev"});
    private static File baseBuiltinDir = ApplicationConfigurator.getPreInstalledPluginsFolder();
    private final Map<String, InstalledPluginDesc> map = new ConcurrentHashMap<String, InstalledPluginDesc>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.plugins.registry");

    @Override
    public boolean isPluginInstalled(String pluginId) {
        return this.map.containsKey(pluginId);
    }

    @Override
    public boolean isPluginInstalledAsDev(String pluginId) {
        return this.map.containsKey(pluginId) && this.map.get((Object)pluginId).origin == InstalledPluginDesc.PluginOrigin.DEV;
    }

    @Override
    public PluginDesc getDesc(String pluginId) {
        return this.map.get((Object)pluginId).desc;
    }

    @Override
    public InstalledPluginDesc getInstalledDesc(String pluginId) {
        return this.map.get(pluginId);
    }

    @Override
    public InstalledPluginDesc getInstalledDescMand(String pluginId) {
        if (!this.map.containsKey(pluginId)) {
            throw ErrorContext.iaef((String)"Plugin %s is not installed", (Object)pluginId, (Object[])new Object[0]);
        }
        return this.map.get(pluginId);
    }

    @Override
    public Collection<InstalledPluginDesc> getLoadedPlugins() {
        return Lists.newArrayList(this.map.values());
    }

    @Override
    public Collection<String> getLoadedPluginIds() {
        return Lists.newArrayList(this.map.keySet());
    }

    @Override
    public File getPluginResourceFolder(String pluginId) {
        return new File(this.getActualPluginFolder(pluginId), "resource");
    }

    @Override
    public File getPluginPythonlibFolder(String pluginId) {
        return new File(this.getActualPluginFolder(pluginId), "python-lib");
    }

    @Override
    public File getPluginJavalibFolder(String pluginId) {
        return new File(this.getActualPluginFolder(pluginId), "java-lib");
    }

    @Override
    public File getActualPluginFolder(String pluginId) {
        InstalledPluginDesc ipd = this.getInstalledDescMand(pluginId);
        File dir = RegularPluginsRegistryService.getPluginFolder(ipd.origin, pluginId);
        if (dir.isDirectory()) {
            return dir;
        }
        throw ErrorContext.iaef((String)"Could not locate plugin %s anymore.", (Object)pluginId, (Object[])new Object[0]);
    }

    public static File getPluginFolder(InstalledPluginDesc.PluginOrigin origin, String pluginId) {
        switch (origin) {
            case DEV: {
                return RegularPluginsRegistryService.getDevPluginFolder(pluginId);
            }
            case INSTALLED: {
                return RegularPluginsRegistryService.getInstalledPluginFolder(pluginId);
            }
            case BUILTIN: {
                return RegularPluginsRegistryService.getBuiltinPluginFolder(pluginId);
            }
        }
        throw new RuntimeException("unreachable");
    }

    public static File getInstalledPluginFolder(String pluginId) {
        return DKUFileUtils.getWithin((File)baseDir, (String[])new String[]{pluginId});
    }

    public static File getDevPluginFolder(String pluginId) {
        return DKUFileUtils.getWithin((File)baseDevDir, (String[])new String[]{pluginId});
    }

    public static File getBuiltinPluginFolder(String pluginId) {
        return DKUFileUtils.getWithin((File)baseBuiltinDir, (String[])new String[]{pluginId});
    }

    public void checkNotRegistered(String pluginId) throws DuplicatePluginException {
        if (this.map.containsKey(pluginId)) {
            throw new DuplicatePluginException("Duplicate plugin identifier: '" + pluginId + "' is already loaded.");
        }
    }

    public void register(String pluginId, InstalledPluginDesc desc) {
        this.map.put(pluginId, desc);
    }

    public void unregister(String pluginId) {
        this.map.remove(pluginId);
    }

    @Override
    public void removeSettings(String pluginId) throws IOException {
        IPluginSettingsDAO dao = (IPluginSettingsDAO)SpringUtils.getBean(IPluginSettingsDAO.class);
        dao.removeSettings(pluginId);
    }

    @Override
    public void setSettings(String pluginId, PluginSettings settings) throws IOException {
        if (!this.map.containsKey(pluginId)) {
            throw ErrorContext.iaef((String)"Plugin %s is not installed", (Object)pluginId, (Object[])new Object[0]);
        }
        IPluginSettingsDAO dao = (IPluginSettingsDAO)SpringUtils.getBean(IPluginSettingsDAO.class);
        dao.setSettings(pluginId, settings);
    }

    @Override
    public PluginSettings getSettings(String pluginId) throws IOException {
        InstalledPluginDesc desc = this.getInstalledDescMand(pluginId);
        try {
            PluginSettings settings;
            IPluginSettingsDAO dao = (IPluginSettingsDAO)SpringUtils.getBean(IPluginSettingsDAO.class);
            if (TransactionContext.hasAttachedTransaction()) {
                settings = dao.getSettings(pluginId);
            } else {
                TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
                try (Transaction t = transactionService.beginRead();){
                    settings = dao.getSettings(pluginId);
                }
            }
            settings.config = PluginConfigUtils.removeOutdatedKeys(desc.desc.params, settings.config);
            settings.presets = PluginConfigUtils.removeOutdatedKeysInPresets(desc.customParameterSets, settings.presets);
            settings.config = PluginConfigUtils.setDefaultValues(desc.desc.params, settings.config);
            PluginConfigUtils.setDefaultParameterSetPermissions(desc, settings);
            return settings;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to read plugin settings. PluginId: " + pluginId));
            throw new Error(e);
        }
    }

    @Override
    public void setProjectSettings(String pluginId, String projectKey, PluginSettings settings) throws IOException {
        if (!this.map.containsKey(pluginId)) {
            throw ErrorContext.iaef((String)"Plugin %s is not installed", (Object)pluginId, (Object[])new Object[0]);
        }
        FileBasedPluginSettingsDAO dao = (FileBasedPluginSettingsDAO)SpringUtils.getBean(FileBasedPluginSettingsDAO.class);
        dao.setProjectSettings(pluginId, projectKey, settings);
    }

    @Override
    public PluginSettings getProjectSettings(String pluginId, String projectKey) throws IOException {
        InstalledPluginDesc desc = this.getInstalledDescMand(pluginId);
        try {
            PluginSettings settings;
            IPluginSettingsDAO dao = (IPluginSettingsDAO)SpringUtils.getBean(IPluginSettingsDAO.class);
            if (TransactionContext.hasAttachedTransaction()) {
                settings = dao.getProjectSettings(pluginId, projectKey);
            } else {
                TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
                try (Transaction t = transactionService.beginRead();){
                    settings = dao.getProjectSettings(pluginId, projectKey);
                }
            }
            settings.config = PluginConfigUtils.removeOutdatedKeys(desc.desc.params, settings.config);
            settings.presets = PluginConfigUtils.removeOutdatedKeysInPresets(desc.customParameterSets, settings.presets);
            settings.config = PluginConfigUtils.setDefaultValues(desc.desc.params, settings.config);
            PluginConfigUtils.setDefaultParameterSetPermissions(desc, settings);
            return settings;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to read plugin settings. PluginId: " + pluginId));
            throw new Error(e);
        }
    }
}

