/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.hive.HProxyKernelHandle;
import com.dataiku.dip.hive.HProxyKernelsManager;
import com.dataiku.dip.hive.HiveLocalMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveScriptPreprocessor;
import com.dataiku.dip.hive.HiveServer2HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveValidationTools;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.consistency.BasicRecipeConsistencyChecker;
import com.dataiku.dip.recipes.consistency.MiscStuffChecker;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.hproxy.model.hive.HiveConfEntry;
import com.dataiku.hproxy.model.hive.ValidationQuery;
import com.dataiku.hproxy.model.hive.ValidationResult;
import com.google.common.collect.Lists;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveRecipeTester {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private HProxyKernelsManager hproxyKernelsManager;
    private static Logger logger = Logger.getLogger((String)"dku.recipes.hive.check");

    public HiveRecipeTester() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public HiveCheckContext startCheckHive(AuthCtx authCtx, SerializedRecipe sa, HiveRecipeMeta.HiveRecipeParams recipeParams, boolean isExplainPlan, String scriptData, RecipeRunnableSubgraph subgraph) throws Exception {
        HiveScriptPreprocessor preprocessor;
        HiveRecipeStatus evr;
        sa = (SerializedRecipe)JSON.parse((String)JSON.json((Object)sa), SerializedRecipe.class);
        HiveCheckContext checking = new HiveCheckContext();
        checking.recipeProjectKey = sa.projectKey;
        checking.recipeParams = recipeParams;
        checking.proceed = false;
        checking.isExplainPlan = isExplainPlan;
        checking.authCtx = authCtx;
        checking.status = evr = new HiveRecipeStatus();
        new BasicRecipeConsistencyChecker(sa).check(evr.topLevelMessages);
        if (evr.topLevelMessages.anyFatal()) {
            return checking;
        }
        new MiscStuffChecker(sa).check(evr.topLevelMessages, authCtx, sa.projectKey);
        checking.subgraph = subgraph;
        RecipeVariablesHelper.RecipeSubstitutionVariablesResult vres = new RecipeVariablesHelper().getRecipeVariables(authCtx, sa.projectKey, checking.subgraph, new HiveSQLDialect());
        checking.status.substitutionVariables = vres.substitutionVariables;
        HiveLocalMetastoreTablesHandler tablesHandler = new HiveLocalMetastoreTablesHandler(sa.projectKey, authCtx, !isExplainPlan, this.metastoreInspectionService.newInspector(authCtx, sa.projectKey));
        checking.clusterSettings = new ClusterSelector().selectForProject(authCtx, sa.projectKey);
        HiveSettings hiveSettings = checking.clusterSettings.getHiveSettings();
        checking.preprocessor = preprocessor = new HiveScriptPreprocessor(authCtx, this.datasetsDAO, this.variablesService.getForProject(sa.projectKey), checking.subgraph, scriptData, tablesHandler, checking.recipeParams.addDkuUdf, hiveSettings);
        preprocessor.setForceInsertOverwrite(!isExplainPlan);
        preprocessor.setSuppressOutputTablesCreation(isExplainPlan);
        preprocessor.setValidationMode(true);
        ((HiveMetastoreTablesHandler)tablesHandler).setHDFSPathPrefix("/dku_flow_hive_tmp/" + System.currentTimeMillis());
        try {
            preprocessor.preprocess();
            if (checking.recipeParams.executionEngine != HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL) {
                for (FlowDataset fds : checking.subgraph.getSourceDatasets()) {
                    Dataset ds = fds.getMandatory(this.datasetsDAO);
                    checking.checkForGlobalHiveSync.add(ds);
                }
            } else {
                for (FlowDataset fds : checking.subgraph.getSourceDatasets()) {
                    Dataset ds = fds.getMandatory(this.datasetsDAO);
                    if (!DatasetInspector.isHDFSDatasetOrHiveTableDataset(ds) || DatasetInspector.canHDFS(ds)) continue;
                    checking.status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INVALID_HIVE_ENGINE, "The recipe has inputs that are not HDFS datasets, precluding the use of the 'Hive CLI (Isolated metastore)' engine", new Object[0]);
                }
            }
            if (preprocessor.queryMayBeUsingWith()) {
                checking.status.topLevelMessages.withWarningV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "The query contains 'WITH...' statements, which cannot be automatically handled by DSS. Put the 'INSERT OVERWRITE...' manually in the query or use a nested subquery", new Object[0]);
            }
            checking.proceed = true;
        }
        catch (Exception e) {
            evr.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "%s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            logger.error((Object)"Preprocessing failed", (Throwable)e);
        }
        return checking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckHive_NT(HiveCheckContext checking) throws Exception {
        ValidationResult rawHiveResponse;
        checking.proceed = false;
        if (checking.recipeParams.executionEngine != HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL) {
            HiveServer2HiveMetastoreSynchronizer synchronizer = new HiveServer2HiveMetastoreSynchronizer(checking.authCtx);
            for (Dataset ds : checking.checkForGlobalHiveSync) {
                if (BuiltinSQLDatasets.HIVE_META.getType().equals(ds.getType())) continue;
                HiveServer2HiveMetastoreSynchronizer.HiveSchemaCompatibility compatible = synchronizer.isExistingSchemaCompatible(ds);
                if (compatible != null && !compatible.tableExists) {
                    checking.status.inputsToSynchronize.add(ds.getLoc());
                }
                if (compatible == null || !compatible.tableExists || compatible.schemaCompatible) continue;
                checking.status.inputsToResynchronize.add(ds.getLoc());
            }
            if (checking.status.inputsToSynchronize != null && checking.status.inputsToSynchronize.size() > 0) {
                checking.status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "The DSS datasets of the recipe inputs have no matching hive table.", new Object[0]);
            }
            if (checking.status.inputsToResynchronize != null && checking.status.inputsToResynchronize.size() > 0) {
                checking.status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "The Hive tables of the recipe inputs are not synchronized with their DSS datasets.", new Object[0]);
            }
        }
        ValidationQuery query = new ValidationQuery(checking.preprocessor.getQuery(), checking.preprocessor.getInitQuery());
        query.isExplainPlan = checking.isExplainPlan;
        if (checking.recipeParams != null) {
            List<SimpleKeyValue> resolvedHiveConf = new HiveConfHelper().getResolvedConf(checking.authCtx, checking.recipeProjectKey, checking.recipeParams);
            for (SimpleKeyValue conf : resolvedHiveConf) {
                query.extraConf.add(new HiveConfEntry(conf.key, conf.value));
            }
        }
        logger.info((Object)("Acquiring a HProxy kernel for Hive validation clusterId=" + checking.clusterSettings.getClusterId()));
        HProxyKernelHandle hproxyKernel = (HProxyKernelHandle)this.hproxyKernelsManager.acquireKernel(checking.clusterSettings);
        boolean kernelReleased = false;
        try {
            int validationTimeout = DKUApp.getParams().getIntParam("dku.hive.queryValidationTimeoutMS", Integer.valueOf(300000));
            rawHiveResponse = (ValidationResult)hproxyKernel.getAPIClient().postFormToJSON("hive/check", validationTimeout, ValidationResult.class, new Object[]{"query", JSON.json((Object)query)});
            this.hproxyKernelsManager.releaseKernel(hproxyKernel);
            kernelReleased = true;
            checking.rawHiveResponse = rawHiveResponse;
            checking.proceed = true;
        }
        catch (SocketTimeoutException e) {
            logger.warn((Object)"Hive query validation timeout", (Throwable)e);
            checking.rawHiveResponse = rawHiveResponse = ValidationResult.makeValidationTimeoutResult();
        }
        finally {
            if (!kernelReleased) {
                this.hproxyKernelsManager.releaseAndKillKernel(hproxyKernel);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Hive validation response: " + JSON.json((Object)rawHiveResponse)));
        }
    }

    public void finishCheckHive_NT(HiveCheckContext checking) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        checking.status.schemaResult = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        List<HiveSchemaHandler.Suggestion> suggs = null;
        try (Transaction t = this.transactionService.beginRead();){
            suggs = HiveSchemaHandler.generateSuggestions(this.datasetsDAO, checking.preprocessor.getTargetsByTableName(), checking.rawHiveResponse.insertOverwrites);
        }
        for (HiveSchemaHandler.Suggestion sugg : suggs) {
            assert (sugg.reasons.size() > 0);
            RecipeSchemaService.ComputableSchemaAutoupdateResult dsRet = RecipeSchemaService.ComputableSchemaAutoupdateResult.forDataset(sugg.dataset.name, sugg.reasons, sugg.dataset.getSchema());
            this.recipeSchemaService.fillAutoupdateFlags(dsRet, Dataset.fromSerialized(sugg.dataset));
            ++checking.status.schemaResult.totalIncompatibilities;
            checking.status.schemaResult.computables.add(dsRet);
        }
        HiveValidationTools.checkIfTryingToWriteOnInputs(checking.subgraph, checking.rawHiveResponse, checking.status.topLevelMessages);
        HiveValidationTools.removeIrrelevantMessages(checking.rawHiveResponse, checking.preprocessor);
        HiveValidationTools.copyMessagesToEnriched(checking.rawHiveResponse, checking.status.topLevelMessages);
        if (checking.status.schemaResult.totalIncompatibilities > 0) {
            checking.status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Schema is incompatible", new Object[0]);
        }
    }

    public static class HiveCheckContext {
        public String recipeProjectKey;
        public boolean proceed;
        public HiveRecipeStatus status;
        public HiveScriptPreprocessor preprocessor;
        public AuthCtx authCtx;
        public List<Dataset> checkForGlobalHiveSync = Lists.newArrayList();
        public ValidationResult rawHiveResponse;
        private RecipeRunnableSubgraph subgraph;
        private HiveRecipeMeta.HiveRecipeParams recipeParams;
        private boolean isExplainPlan;
        public ClusterSettings clusterSettings;
    }

    public static class HiveRecipeStatus
    extends CodeBasedRecipeStatus {
        public RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult;
        public List<DatasetLocUtils.DatasetLoc> inputsToSynchronize = Lists.newArrayList();
        public List<DatasetLocUtils.DatasetLoc> inputsToResynchronize = Lists.newArrayList();

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            return ret;
        }
    }
}

