/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.univariate.LeveneTestNSamp;
import com.dataiku.dip.eda.compute.stats.LeveneCenter;
import com.dataiku.dip.recipes.eda.EDASchemaColumns;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.recipes.eda.stats.AbstractTwoSampleTestStat;
import com.dataiku.dip.utils.JSON;
import javax.annotation.Nullable;

public class TwoSampleLeveneTestStat
extends AbstractTwoSampleTestStat {
    private static final String TWO_SAMPLE_LEVENE_TEST = "LEVENE_TEST_TWO_SAMPLE";
    public LeveneCenter center = LeveneCenter.MEDIAN;
    @Nullable
    public Double proportionToTrim;

    public TwoSampleLeveneTestStat(String testColumn, String groupByColumn, @Nullable String[] groupValues1, @Nullable String[] groupValues2, LeveneCenter center, @Nullable Double proportionToTrim) {
        super(testColumn, groupByColumn, groupValues1, groupValues2);
        this.center = center;
        this.proportionToTrim = proportionToTrim;
    }

    public TwoSampleLeveneTestStat() {
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        super.fillTestParams(row, cf);
        row.put(cf.column("test"), TWO_SAMPLE_LEVENE_TEST);
        AbstractTestStat.LeveneCenterSettings leveneCenterSettings = new AbstractTestStat.LeveneCenterSettings(this.center, this.proportionToTrim);
        row.put(cf.column("center_settings"), JSON.json((Object)leveneCenterSettings));
    }

    @Override
    protected Computation getTestComputation(StatsTestRecipePayloadParams<?> payloadParams) {
        return new LeveneTestNSamp(this.testColumn, this.getPopulationGrouping(), this.center, this.proportionToTrim);
    }

    @Override
    protected void fillTestResult(AvailableResult result, double significanceLevel, ColumnFactory cf, Row row) {
        LeveneTestNSamp.LeveneTestNSampResult tr = result.as(LeveneTestNSamp.LeveneTestNSampResult.class);
        if (tr.centers.length > 2) {
            throw new IllegalArgumentException(String.format("Expected exactly two center values (one for each sample), got %d", tr.centers.length));
        }
        row.put(cf.column(EDASchemaColumns.leveneCenterValue(1)), tr.centers[0]);
        row.put(cf.column(EDASchemaColumns.leveneCenterValue(2)), tr.centers[1]);
        double pValue = tr.pvalue;
        String conclusion = TwoSampleLeveneTestStat.conclusion(pValue, significanceLevel);
        row.put(cf.column("f_statistic"), tr.statistic);
        row.put(cf.column("p_value"), pValue);
        row.put(cf.column("conclusion"), conclusion);
    }
}

