/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.fromapp;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.CreationJobDef;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.dataflow.kernel.slave.JobKernelAPIClient;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.fromapp.AppRecipeMeta;
import com.dataiku.dip.recipes.fromapp.AppRecipeParams;
import com.dataiku.dip.recipes.fromapp.FlowComputableForRoleMappingsBuilder;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.steps.BuildFlowItemStepRunner;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.security.DiagConfigRedactionUtils;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.datasets.DatasetRenameService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AppRecipeRunner
implements RecipeRunner,
FlowRunnable,
AbortableRecipeRunner {
    public static final String APP_AS_RECIPE_INSTANCE_NAME_PREFIX = "Execute recipe ";
    protected static final String PROJECTS_PUBLIC_API = "/dip/publicapi/projects/";
    private static final Exception SCENARIO_ABORTED_EXCEPTION = new Exception("Aborted");
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private APITicketService apiTicketService;
    private final AppRecipeMeta meta;
    private final JobActivity activity;
    private final RunnableSubgraph subgraph;
    private final FlowRecipe applicationAsRecipe;
    private volatile boolean aborted = false;
    private JobKernelAPIClient client;
    private String scenarioRunId;
    private final List<String> directJobsIds = new ArrayList<String>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.app");

    public AppRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = activity.getSubgraph();
        this.applicationAsRecipe = ((RecipeRunnableSubgraph)this.subgraph).getRecipe();
        this.meta = (AppRecipeMeta)RecipeRegistry.getMeta(activity);
        activity.initStatus();
    }

    private static String buildProjectPublicApiPrefix(String projectKey) {
        return PROJECTS_PUBLIC_API + projectKey;
    }

    private static String buildJobPublicAPI(String projectKey) {
        return AppRecipeRunner.buildProjectPublicApiPrefix(projectKey) + "/jobs/";
    }

    @VisibleForTesting
    protected static String buildJobPublicAPI(String projectKey, String jobId) {
        return AppRecipeRunner.buildProjectPublicApiPrefix(projectKey) + "/jobs/" + jobId + "/";
    }

    private static String buildRecipePublicAPI(String projectKey, SerializedRecipe recipe) {
        return AppRecipeRunner.buildRecipesPublicAPI(projectKey) + recipe.name;
    }

    private static String buildRecipesPublicAPI(String projectKey) {
        return AppRecipeRunner.buildProjectPublicApiPrefix(projectKey) + "/recipes/";
    }

    private static String buildScenarioPublicAPI(String projectKey, String scenarioId) {
        return AppRecipeRunner.buildProjectPublicApiPrefix(projectKey) + "/scenarios/" + scenarioId;
    }

    private static String buildVariablePublicAPI(String projectKey) {
        return AppRecipeRunner.buildProjectPublicApiPrefix(projectKey) + "/variables";
    }

    @VisibleForTesting
    protected static CreationJobDef buildCreationJobDef(BuildFlowItemStepRunner.BuildFlowItemStepParams buildFlowItemStepParams) {
        CreationJobDef creationJobDef = new CreationJobDef();
        for (FlowComputableSpecification build : buildFlowItemStepParams.builds) {
            CreationJobDef.Output output = new CreationJobDef.Output();
            output.projectKey = build.projectKey;
            output.partition = build.partitionsSpec;
            output.type = build.type;
            output.id = build.itemId;
            creationJobDef.outputs.add(output);
        }
        creationJobDef.type = buildFlowItemStepParams.jobType;
        creationJobDef.stopAtFlowZoneBoundary = buildFlowItemStepParams.stopAtFlowZoneBoundary;
        creationJobDef.refreshHiveMetastore = buildFlowItemStepParams.refreshHiveMetastore;
        creationJobDef.autoUpdateSchemaBeforeEachRecipeRun = buildFlowItemStepParams.autoUpdateSchemaBeforeEachRecipeRun;
        return creationJobDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        this.activity.setStatusMessage("Creating instance");
        AppManifest.AppUseAsRecipeSettings useAsRecipeSettings = this.meta.getManifest().useAsRecipeSettings;
        AppRecipeParams params = this.applicationAsRecipe.getModel().getParamsAs(AppRecipeParams.class);
        String scenarioId = useAsRecipeSettings.runScenarioTile.scenarioId;
        if (StringUtils.isBlank((String)scenarioId)) {
            throw ErrorContext.iaef((String)"No scenario defined for application-as-recipe. Defined one for app %s", (Object)this.meta.getAppId(), (Object[])new Object[0]);
        }
        this.client = new JobKernelAPIClient(this.apiTicketService);
        String applicationInstanceProjectKey = this.instantiateApplication();
        HashSet sourceProjects = Sets.newHashSet();
        try {
            this.activity.setStatusMessage("Executing application-as-recipe");
            logger.info((Object)"Performing input replacements");
            Map<String, FlowComputable> inputReplacements = new FlowComputableForRoleMappingsBuilder.InputFlowComputableForRoleMappingsBuilder(this.applicationAsRecipe, this.subgraph).build(useAsRecipeSettings);
            sourceProjects.addAll(this.addExpositionRulesToSourceProjects(applicationInstanceProjectKey, inputReplacements));
            this.swapInputsInTargetProject(applicationInstanceProjectKey, inputReplacements);
            this.enrichTargetProjectVariables(applicationInstanceProjectKey, params);
            Scenario scenario = (Scenario)this.client.get(AppRecipeRunner.buildScenarioPublicAPI(applicationInstanceProjectKey, scenarioId), Scenario.class);
            boolean canRunDirectJobs = AppRecipeRunner.checkCanRunJobsDirectly(scenario);
            if (canRunDirectJobs) {
                logger.info((Object)"Replacements done, running direct job(s)");
                this.runDirectJobsFromScenario(applicationInstanceProjectKey, scenario);
                logger.info((Object)"Direct job(s) ran. Will now perform outputs copy");
            } else {
                logger.info((Object)"Replacements done, running scenario");
                this.runScenario(scenarioId, applicationInstanceProjectKey);
                logger.info((Object)"Scenario ran. Will now perform outputs copy");
            }
            this.copyOutputs(useAsRecipeSettings, applicationInstanceProjectKey);
        }
        finally {
            if (this.scenarioRunId != null) {
                this.collectScenarioLogs(scenarioId, applicationInstanceProjectKey, this.scenarioRunId);
            }
            if (!this.directJobsIds.isEmpty()) {
                this.collectDirectJobsLogs(applicationInstanceProjectKey, this.directJobsIds);
            }
            if (!params.keepInstance) {
                this.cleanUp(applicationInstanceProjectKey, sourceProjects);
            }
        }
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    @VisibleForTesting
    protected static ReportItem.Outcome updateStatusWithStepOutcome(ReportItem.Outcome currentOutcome, Step step, ReportItem.Outcome stepOutcome) {
        if (step.resetsScenarioStatus()) {
            currentOutcome = ReportItem.Outcome.SUCCESS;
        }
        switch (stepOutcome) {
            case SUCCESS: {
                break;
            }
            case WARNING: {
                if (currentOutcome == ReportItem.Outcome.ABORTED || currentOutcome == ReportItem.Outcome.FAILED) break;
                currentOutcome = ReportItem.Outcome.WARNING;
                break;
            }
            case FAILED: {
                if (currentOutcome == ReportItem.Outcome.ABORTED) break;
                currentOutcome = ReportItem.Outcome.FAILED;
                break;
            }
            case ABORTED: {
                currentOutcome = ReportItem.Outcome.ABORTED;
            }
        }
        return currentOutcome;
    }

    @VisibleForTesting
    protected static boolean checkCanRunJobsDirectly(Scenario scenario) {
        if (!StepBasedScenarioRunner.META.getType().equals(scenario.getType())) {
            return false;
        }
        StepBasedScenarioRunner.StepBasedScenarioParams stepBasedScenarioParams = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
        if (stepBasedScenarioParams == null) {
            return false;
        }
        for (Step step : stepBasedScenarioParams.steps) {
            if (!step.enabled) continue;
            StepParams stepParams = step.params;
            if (!(stepParams instanceof BuildFlowItemStepRunner.BuildFlowItemStepParams)) {
                return false;
            }
            BuildFlowItemStepRunner.BuildFlowItemStepParams buildFlowItemStepParams = (BuildFlowItemStepRunner.BuildFlowItemStepParams)stepParams;
            if (step.maxRetriesOnFail > 0) {
                return false;
            }
            if (buildFlowItemStepParams.handleWarningsAs != ReportItem.Outcome.WARNING) {
                return false;
            }
            switch (step.runConditionType) {
                case DISABLED: 
                case RUN_ALWAYS: {
                    break;
                }
                case RUN_CONDITIONALLY: {
                    return false;
                }
                case RUN_IF_STATUS_MATCH: {
                    if (step.runConditionStatuses.contains((Object)ReportItem.Outcome.SUCCESS) && !step.runConditionStatuses.contains((Object)ReportItem.Outcome.FAILED)) break;
                    return false;
                }
            }
        }
        return true;
    }

    private void runDirectJobsFromScenario(String applicationInstanceProjectKey, Scenario scenario) throws Exception {
        StepBasedScenarioRunner.StepBasedScenarioParams stepBasedScenarioParams = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
        ReportItem.Outcome currentOutcome = ReportItem.Outcome.SUCCESS;
        for (Step step : stepBasedScenarioParams.steps) {
            ReportItem.Outcome stepOutcome;
            StepParams stepParams;
            if (!step.enabled || Step.RunConditionType.DISABLED.equals((Object)step.runConditionType) || Step.RunConditionType.RUN_IF_STATUS_MATCH.equals((Object)step.runConditionType) && !step.runConditionStatuses.contains((Object)currentOutcome) || !((stepParams = step.params) instanceof BuildFlowItemStepRunner.BuildFlowItemStepParams)) continue;
            BuildFlowItemStepRunner.BuildFlowItemStepParams buildFlowItemStepParams = (BuildFlowItemStepRunner.BuildFlowItemStepParams)stepParams;
            try {
                stepOutcome = this.runDirectJobForStep(applicationInstanceProjectKey, buildFlowItemStepParams);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to run direct job for step : " + step.id), (Throwable)e);
                stepOutcome = ReportItem.Outcome.FAILED;
            }
            currentOutcome = AppRecipeRunner.updateStatusWithStepOutcome(currentOutcome, step, stepOutcome);
        }
        if (ReportItem.Outcome.FAILED == currentOutcome || ReportItem.Outcome.ABORTED == currentOutcome) {
            throw new Exception("Job " + String.valueOf((Object)currentOutcome));
        }
    }

    private ReportItem.Outcome runDirectJobForStep(String projectKey, BuildFlowItemStepRunner.BuildFlowItemStepParams buildFlowItemStepParams) throws IOException, InterruptedException {
        CreationJobDef creationJobDef = AppRecipeRunner.buildCreationJobDef(buildFlowItemStepParams);
        JobDef jobDef = (JobDef)this.client.postObject(AppRecipeRunner.buildJobPublicAPI(projectKey), JobDef.class, creationJobDef);
        String jobId = jobDef.id;
        EnhancedSerializedJobStatus enhancedJobStatus = null;
        while (enhancedJobStatus == null || !enhancedJobStatus.baseStatus.state.isFinished()) {
            Thread.sleep(1000L);
            enhancedJobStatus = (EnhancedSerializedJobStatus)this.client.get(AppRecipeRunner.buildJobPublicAPI(projectKey, jobId), EnhancedSerializedJobStatus.class);
        }
        this.directJobsIds.add(jobId);
        return switch (enhancedJobStatus.baseStatus.state) {
            case JobState.DONE -> {
                if (enhancedJobStatus.baseStatus.activities.values().stream().anyMatch(status -> status.getWarningsTotalCount() > 0)) {
                    yield ReportItem.Outcome.WARNING;
                }
                yield ReportItem.Outcome.SUCCESS;
            }
            case JobState.FAILED -> {
                if (buildFlowItemStepParams.shouldProceedOnFailure()) {
                    yield ReportItem.Outcome.WARNING;
                }
                yield ReportItem.Outcome.FAILED;
            }
            case JobState.ABORTED -> ReportItem.Outcome.ABORTED;
            default -> throw new IllegalStateException("unreachable");
        };
    }

    private void cleanUp(String applicationInstanceProjectKey, Set<String> sourceProjects) throws IOException {
        try (JobKernelAPIClient clientForCleanUp = new JobKernelAPIClient(this.apiTicketService);){
            logger.info((Object)"Deleting app instance used to run the recipe");
            clientForCleanUp.delete(AppRecipeRunner.buildProjectPublicApiPrefix(applicationInstanceProjectKey), Void.class, new Object[]{"clearManagedDatasets", true, "clearOutputManagedFolders", true});
            logger.info((Object)("Cleanup exposition rules on " + JSON.json(sourceProjects)));
            for (String sourceProjectKey : sourceProjects) {
                clientForCleanUp.putObject(AppRecipeRunner.buildProjectPublicApiPrefix(sourceProjectKey) + "/unexpose-to-projects", Void.class, Lists.newArrayList((Object[])new String[]{applicationInstanceProjectKey}));
            }
        }
    }

    private ScenarioRun runScenario(String scenarioId, String applicationInstanceProjectKey) throws Exception {
        ScenariosService.ScenarioRunDetails scenarioRunDetails;
        TriggerFire scenarioTriggerFire = (TriggerFire)this.client.postObject(AppRecipeRunner.buildScenarioPublicAPI(applicationInstanceProjectKey, scenarioId) + "/run", TriggerFire.class, this.buildScenarioRunParams());
        ScenarioRun scenarioRun = null;
        while (scenarioRun == null && !this.aborted) {
            Thread.sleep(1000L);
            scenarioRunDetails = (ScenariosService.ScenarioRunDetails)this.client.getForm(AppRecipeRunner.buildScenarioPublicAPI(applicationInstanceProjectKey, scenarioId) + "/get-run-for-trigger", ScenariosService.ScenarioRunDetails.class, new Object[]{"triggerId", scenarioTriggerFire.getTrigger().getId(), "triggerRunId", scenarioTriggerFire.getRunId()});
            if (scenarioRunDetails.scenarioRun == null) continue;
            scenarioRun = scenarioRunDetails.scenarioRun;
            this.scenarioRunId = scenarioRun.getRunId();
        }
        if (this.aborted) {
            throw SCENARIO_ABORTED_EXCEPTION;
        }
        while (!(scenarioRun == null || scenarioRun.getResult() != null && scenarioRun.getResult().getOutcome() != null || this.aborted)) {
            Thread.sleep(5000L);
            scenarioRunDetails = (ScenariosService.ScenarioRunDetails)this.client.get(AppRecipeRunner.buildScenarioPublicAPI(applicationInstanceProjectKey, scenarioId) + "/" + scenarioRun.getRunId() + "/", ScenariosService.ScenarioRunDetails.class);
            scenarioRun = scenarioRunDetails.scenarioRun;
        }
        if (this.aborted) {
            throw SCENARIO_ABORTED_EXCEPTION;
        }
        if (scenarioRun == null) {
            throw new IllegalStateException("Unable to find scenario run");
        }
        if (scenarioRun.getResult() == null) {
            throw new IllegalStateException("Scenario didn't finish");
        }
        if (scenarioRun.getResult().getOutcome() == null) {
            throw new IllegalStateException("Scenario outcome unavailable");
        }
        if (scenarioRun.getResult().getOutcome() != ReportItem.Outcome.SUCCESS && scenarioRun.getResult().getOutcome() != ReportItem.Outcome.WARNING) {
            throw new Exception("Scenario " + String.valueOf((Object)scenarioRun.getResult().getOutcome()));
        }
        return scenarioRun;
    }

    private void collectScenarioLogs(String scenarioId, String applicationInstanceProjectKey, String scenarioRunId) {
        this.activity.setStatusMessage("Collecting scenario logs");
        try {
            HttpEntity entity = this.client.postFormToStream("/dip/api/tintercom/scenarios/download-run-diagnosis", new Object[]{"projectKey", applicationInstanceProjectKey, "scenarioId", scenarioId, "runId", scenarioRunId});
            File jobFolder = FlowJobUtils.getCurrentJobFolder();
            File diagFile = new File(jobFolder, JobContext.getCurrentJobContext().activity + "_diag.zip");
            try (FileOutputStream os = new FileOutputStream(diagFile);){
                IOUtils.copy((InputStream)entity.getContent(), (OutputStream)os);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to grab the scenario logs in the temp instance", (Throwable)e);
        }
    }

    private void collectDirectJobsLogs(String applicationInstanceProjectKey, List<String> jobIds) {
        this.activity.setStatusMessage("Collecting logs for direct jobs");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        File jobFolder = FlowJobUtils.getCurrentJobFolder();
        for (String jobId : jobIds) {
            try {
                File jobDir = LogsService.getJobFolder(applicationInstanceProjectKey, jobId);
                Object id = "dss-job-diag-" + applicationInstanceProjectKey + "-" + jobId;
                id = RelFile.ensureValidName((String)id);
                if (!jobDir.exists()) continue;
                File diagFile = new File(jobFolder, applicationInstanceProjectKey + "_" + jobId + "_diag.zip");
                try (ZipWriteFS zipDiag = new ZipWriteFS((OutputStream)new FileOutputStream(diagFile), 1);){
                    zipDiag.makeDirectory((String)id);
                    DiagConfigRedactionUtils.buildJobDiag(jobDir, zipDiag.directoryView((String)id), t.getUser());
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to grab the logs for job " + jobId + " in the temp instance"), (Throwable)e);
            }
        }
    }

    private void copyOutputs(AppManifest.AppUseAsRecipeSettings useAsRecipeSettings, String applicationInstanceProjectKey) throws Exception {
        Map<String, FlowComputable> outputCopies = new FlowComputableForRoleMappingsBuilder.OutputFlowComputableForRoleMappingsBuilder(this.applicationAsRecipe, this.subgraph).build(useAsRecipeSettings);
        for (Map.Entry<String, FlowComputable> targetOutput : outputCopies.entrySet()) {
            this.performCopyToTargetOutput(applicationInstanceProjectKey, targetOutput);
        }
    }

    private void performCopyToTargetOutput(String applicationInstanceProjectKey, Map.Entry<String, FlowComputable> targetOutput) throws Exception {
        String objectId = targetOutput.getKey();
        FlowComputable target = targetOutput.getValue();
        DatasetLocUtils.DatasetLoc targetLoc = DatasetLocUtils.resolveFull(target.getFullId());
        JsonObject copyRequest = new JsonObject();
        copyRequest.addProperty("targetProjectKey", targetLoc.getProjectKey());
        Output.WriteMode writeMode = Output.WriteMode.OVERWRITE;
        for (SerializedRecipe.RecipeOutput recipeOutput : this.applicationAsRecipe.getModel().getFlatOutputs()) {
            if (!targetLoc.equals(recipeOutput.getLoc(this.applicationAsRecipe.getProjectKey()))) continue;
            writeMode = recipeOutput.appendMode ? Output.WriteMode.APPEND : Output.WriteMode.OVERWRITE;
        }
        copyRequest.addProperty("writeMode", writeMode.name());
        logger.infoV("Copy %s to %s (%s)", new Object[]{objectId, target.getFullId(), writeMode.name()});
        switch (target.getType()) {
            case DATASET: {
                copyRequest.addProperty("syncSchema", Boolean.valueOf(true));
                copyRequest.addProperty("targetDatasetName", targetLoc.getId());
                FutureResponse<WarningsContext> copyDatasetAction = (FutureResponse<WarningsContext>)this.client.postObject(AppRecipeRunner.buildProjectPublicApiPrefix(applicationInstanceProjectKey) + "/datasets/" + objectId + "/actions/copyTo", (TypeToken)new TypeToken<FutureResponse<WarningsContext>>(){}, copyRequest);
                copyDatasetAction = this.waitForFuture(copyDatasetAction, new TypeToken<FutureResponse<WarningsContext>>(){});
                logger.info((Object)("Copy done: " + JSON.pretty((Object)copyDatasetAction.result)));
                break;
            }
            case MANAGED_FOLDER: {
                copyRequest.addProperty("targetFolderId", targetLoc.getId());
                FutureResponse<List<FSPath>> copyFolderAction = (FutureResponse<List<FSPath>>)this.client.postObject(AppRecipeRunner.buildProjectPublicApiPrefix(applicationInstanceProjectKey) + "/managedfolders/" + objectId + "/actions/copyTo", (TypeToken)new TypeToken<FutureResponse<List<FSPath>>>(){}, copyRequest);
                copyFolderAction = this.waitForFuture(copyFolderAction, new TypeToken<FutureResponse<List<FSPath>>>(){});
                logger.info((Object)("Copy done: " + JSON.pretty((Object)copyFolderAction.result)));
                break;
            }
            default: {
                logger.warnV("Unsupported output type %s", new Object[]{target.getType()});
            }
        }
    }

    private JsonObject buildScenarioRunParams() {
        JobContext currentJobContext = JobContext.getCurrentJobContext();
        JsonObject scenarioRunParams = new JsonObject();
        scenarioRunParams.addProperty("projectKey", this.applicationAsRecipe.getProjectKey());
        scenarioRunParams.addProperty("jobId", currentJobContext.jobId);
        scenarioRunParams.addProperty("activityId", currentJobContext.activity);
        return scenarioRunParams;
    }

    private void enrichTargetProjectVariables(String applicationInstanceProjectKey, AppRecipeParams params) throws IOException {
        if (params.variables != null && params.variables.size() > 0) {
            logger.info((Object)"Setting project variables");
            VariablesService.ProjectVariables projectVariables = (VariablesService.ProjectVariables)this.client.get(AppRecipeRunner.buildVariablePublicAPI(applicationInstanceProjectKey), VariablesService.ProjectVariables.class);
            for (Map.Entry kv : params.variables.entrySet()) {
                projectVariables.standard.add((String)kv.getKey(), (JsonElement)kv.getValue());
            }
            this.client.putObject(AppRecipeRunner.buildVariablePublicAPI(applicationInstanceProjectKey), Void.class, projectVariables);
        }
    }

    private Set<String> addExpositionRulesToSourceProjects(String applicationInstanceProjectKey, Map<String, FlowComputable> inputReplacements) throws IOException {
        ListMultimap<String, ExposedObject> expositions = this.buildExposedObjectsPerSourceProject(applicationInstanceProjectKey, inputReplacements);
        logger.infoV("Will add the following rules: %s", new Object[]{JSON.pretty(expositions)});
        Set sourceProjects = expositions.keySet();
        for (String sourceProjectKey : sourceProjects) {
            List toExpose = expositions.get((Object)sourceProjectKey);
            logger.infoV("Adding rules to project %s in to expose: %s", new Object[]{sourceProjectKey, JSON.json((Object)toExpose)});
            this.client.putObject(PROJECTS_PUBLIC_API + sourceProjectKey + "/expose", Void.class, toExpose);
        }
        return sourceProjects;
    }

    private ListMultimap<String, ExposedObject> buildExposedObjectsPerSourceProject(String applicationInstanceProjectKey, Map<String, FlowComputable> inputReplacements) {
        ArrayListMultimap expositions = ArrayListMultimap.create();
        for (FlowComputable source : inputReplacements.values()) {
            DatasetLocUtils.DatasetLoc sourceLoc = DatasetLocUtils.resolveFull(source.getFullId());
            String sourceProjectKey = sourceLoc.getProjectKey();
            ExposedObject.Rule rule = new ExposedObject.Rule();
            rule.targetProject = applicationInstanceProjectKey;
            ExposedObject exposed = new ExposedObject(source.getType().toTaggableType(), sourceLoc.getId(), false);
            exposed.rules.add(rule);
            expositions.put((Object)sourceProjectKey, (Object)exposed);
        }
        return expositions;
    }

    private String instantiateApplication() throws Exception {
        AppsService.AppInstantiationRequest appInstantiationRequest = this.buildAppInstantiationRequest(this.applicationAsRecipe.getModel());
        logger.infoV("Create instance to run the recipe : %s", new Object[]{JSON.json((Object)appInstantiationRequest)});
        try {
            FutureResponse<AppsService.AppInstantiationResult> fr = (FutureResponse<AppsService.AppInstantiationResult>)this.client.postObject("/dip/publicapi/apps/" + this.meta.getAppId() + "/instances", (TypeToken)new TypeToken<FutureResponse<AppsService.AppInstantiationResult>>(){}, appInstantiationRequest);
            fr = this.waitForFuture(fr, new TypeToken<FutureResponse<AppsService.AppInstantiationResult>>(){});
            AppsService.AppInstantiationResult instantiationResult = (AppsService.AppInstantiationResult)((Object)fr.result);
            if (instantiationResult == null) {
                throw ErrorContext.iaef((String)"Unable to instantiate app %s to run app-as-recipe", (Object)this.meta.getAppId(), (Object[])new Object[0]);
            }
            if (!Objects.equals(appInstantiationRequest.targetProjectKey, instantiationResult.targetProjectKey)) {
                throw ErrorContext.icef((String)"Expecting app instance with project key %s but got %s", (Object)appInstantiationRequest.targetProjectKey, (Object[])new Object[]{instantiationResult.targetProjectKey});
            }
            return instantiationResult.targetProjectKey;
        }
        catch (APIError.SerializedErrorException e) {
            logger.error((Object)("Failed to instantiate app, backend-side : " + e.error.getLoggable()));
            throw e;
        }
    }

    private AppsService.AppInstantiationRequest buildAppInstantiationRequest(SerializedRecipe serializedRecipe) {
        String randomness = SecretKeyGenerator.generate((int)8);
        JsonObject variables = new JsonObject();
        variables.addProperty("projectRandomKey", randomness);
        AppsService.AppInstantiationRequest appInstantiationRequest = new AppsService.AppInstantiationRequest();
        appInstantiationRequest.targetProjectKey = String.format("RUN_%s_%s", serializedRecipe.getId().replaceAll("[^a-zA-Z0-9]+", "_"), randomness);
        appInstantiationRequest.targetProjectName = APP_AS_RECIPE_INSTANCE_NAME_PREFIX + serializedRecipe.getFullId();
        appInstantiationRequest.appInstanceCreatorFullId = serializedRecipe.getFullId();
        appInstantiationRequest.variables = variables;
        appInstantiationRequest.isTemporaryAppInstance = true;
        return appInstantiationRequest;
    }

    private void swapInputsInTargetProject(String applicationInstanceProjectKey, Map<String, FlowComputable> newInputs) throws IOException {
        logger.info((Object)"Swapping recipes' inputs for the exposed ones");
        List recipesInTargetProject = (List)this.client.get(AppRecipeRunner.buildRecipesPublicAPI(applicationInstanceProjectKey), (TypeToken)new TypeToken<List<SerializedRecipe>>(){});
        for (SerializedRecipe recipeInTargetProject : recipesInTargetProject) {
            int numberOfChangedInput = 0;
            for (SerializedRecipe.RecipeInput recipeInput : recipeInTargetProject.getFlatInputs()) {
                FlowComputable replacement = newInputs.get(recipeInput.ref);
                if (replacement == null) continue;
                logger.infoV("Replacing input %s of recipe %s by %s", new Object[]{recipeInput.ref, recipeInTargetProject.getId(), replacement.getFullId()});
                if (FlowComputable.FCType.DATASET.equals((Object)replacement.getType())) {
                    DatasetRenameService.performDatasetRenamingForRecipeInplace(AnyLoc.resolveSmart(this.applicationAsRecipe.getProjectKey(), recipeInput.ref).toDatasetLoc(), AnyLoc.resolveFull(replacement.getFullId()).toDatasetLoc(), recipeInTargetProject, this.applicationAsRecipe.getProjectKey());
                }
                recipeInput.ref = replacement.getFullId();
                ++numberOfChangedInput;
            }
            if (numberOfChangedInput <= 0) continue;
            String recipePublicAPI = AppRecipeRunner.buildRecipePublicAPI(applicationInstanceProjectKey, recipeInTargetProject);
            SerializedRecipe.SerializedRecipeAndPayload recipeAndPayload = (SerializedRecipe.SerializedRecipeAndPayload)this.client.get(recipePublicAPI, SerializedRecipe.SerializedRecipeAndPayload.class);
            recipeAndPayload.recipe = recipeInTargetProject;
            this.client.putObject(recipePublicAPI, Void.class, recipeAndPayload);
            logger.infoV("Changed %s inputs in recipe %s", new Object[]{numberOfChangedInput, recipeInTargetProject.getId()});
        }
    }

    private <T> FutureResponse<T> waitForFuture(FutureResponse<T> fr, TypeToken<FutureResponse<T>> clazz) throws Exception {
        while (!(fr.hasResult || fr.aborted || this.aborted)) {
            logger.info((Object)("Wait some more for the instantiation to finish on future " + fr.jobId));
            Thread.sleep(5000L);
            fr = (FutureResponse)this.client.get("/dip/publicapi/futures/" + fr.jobId, clazz);
        }
        if (this.aborted) {
            throw SCENARIO_ABORTED_EXCEPTION;
        }
        return fr;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    @Override
    public void notifyBeforeAborting() {
        this.aborted = true;
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }
}

