/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.prediction.overrides.ReadOnlyColumnFactory;
import com.dataiku.dip.analysis.ml.prediction.overrides.ReadOnlyRowObservation;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.docextraction.ScreenshotterService;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.docextraction.VLMExtractor;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.StructuredExtractorResponseOrError;
import com.dataiku.dip.docextraction.common.VlmExtractorResponseOrError;
import com.dataiku.dip.docextraction.common.chunks.StructuredExtractionChunk;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.online.utils.BlockingQueryProcessor;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRule;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedData;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedDataWriter;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.MultimodalTextPart;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.SingleExtractedChunk;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.StructuredRuleChunk;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.VlmRuleChunk;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsIndexer;
import com.dataiku.dip.recipes.nlp.embed_documents.IndexerComputationResult;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.shaker.processors.expr.RecursiveCharacterTextSplitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.scoring.util.RawObservation;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DocExtractionRuleApplier {
    List<DocExtractionRule> rules;
    DocExtractionRule allOtherFilesRule;
    ManagedFolder assetsOutputFolder;
    EnrichedLLMStructuredRef embeddingModelRef;
    Boolean alwaysStoreScreenshots;
    Boolean storeOriginalImages;
    boolean splittingAllowed;
    private boolean prependFullOutlineToEachChunksPriorSplitting;
    private boolean useSeparatedChunksForImages;
    AuthCtx authCtx;
    String projectKey;
    APITicketService ticketService;
    JobActivity activity;
    ScreenshotterService screenshotterService;
    ExecutorService extractionExecutorService;
    ExecutorService postExtractionExecutorService;
    int DEFAULT_PAGINATION_SIZE = DKUApp.getParams().getIntParam("dku.llm.embedDocuments.screenshotPaginationSize", Integer.valueOf(100));
    int MAX_PARALLELISM = DKUApp.getParams().getIntParam("dku.llm.embedDocuments.maxParallelism", Integer.valueOf(4));
    int MAX_POST_EXTRACTION_PARALLELISM = DKUApp.getParams().getIntParam("dku.llm.embedDocuments.maxPostExtractionParallelism", Integer.valueOf(4));
    Set<String> unmatchedDocuments = Sets.newConcurrentHashSet();
    Set<String> processingFailedDocuments = Sets.newConcurrentHashSet();
    List<CompletableFuture<Void>> documentsExtractionTaskList = new ArrayList<CompletableFuture<Void>>();
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp.rule_applier");

    public DocExtractionRuleApplier(List<DocExtractionRule> rules, DocExtractionRule allOtherFilesRule, EnrichedLLMStructuredRef embeddingModelRef, @Nullable ManagedFolder outfolder, AuthCtx authCtx, String projectKey, APITicketService ticketService, JobActivity activity, ScreenshotterService screenshotterService) {
        this(rules, allOtherFilesRule, embeddingModelRef, outfolder, authCtx, projectKey, ticketService, activity, screenshotterService, null, true, true, true, true);
    }

    public DocExtractionRuleApplier(List<DocExtractionRule> rules, DocExtractionRule allOtherFilesRule, @Nullable ManagedFolder outfolder, AuthCtx authCtx, String projectKey, APITicketService ticketService, JobActivity activity, ScreenshotterService screenshotterService, boolean alwaysStoreScreenshots, boolean storeOriginalImages) {
        this(rules, allOtherFilesRule, null, outfolder, authCtx, projectKey, ticketService, activity, screenshotterService, alwaysStoreScreenshots, false, false, false, storeOriginalImages);
    }

    public DocExtractionRuleApplier(List<DocExtractionRule> rules, DocExtractionRule allOtherFilesRule, EnrichedLLMStructuredRef embeddingModelRef, @Nullable ManagedFolder outfolder, AuthCtx authCtx, String projectKey, APITicketService ticketService, JobActivity activity, ScreenshotterService screenshotterService, @Nullable Boolean alwaysStoreScreenshots, boolean splittingAllowed, boolean prependFullOutlineToEachChunksPriorSplitting, boolean useSeparatedChunksForImages, boolean storeOriginalImages) {
        this.rules = rules;
        this.allOtherFilesRule = allOtherFilesRule;
        this.assetsOutputFolder = outfolder;
        this.embeddingModelRef = embeddingModelRef;
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.ticketService = ticketService;
        this.activity = activity;
        this.screenshotterService = screenshotterService;
        this.alwaysStoreScreenshots = alwaysStoreScreenshots;
        this.storeOriginalImages = storeOriginalImages;
        this.splittingAllowed = splittingAllowed;
        this.prependFullOutlineToEachChunksPriorSplitting = prependFullOutlineToEachChunksPriorSplitting;
        this.useSeparatedChunksForImages = useSeparatedChunksForImages;
        this.extractionExecutorService = new ThreadPoolExecutor(this.MAX_PARALLELISM, this.MAX_PARALLELISM, 0L, TimeUnit.MILLISECONDS, new BlockingQueryProcessor.OfferBlockingLinkedBlockingQueue<Runnable>(this.MAX_PARALLELISM * 2), new ThreadFactoryBuilder().setNameFormat("embed-documents-rule-applier-extraction-%d").build());
        this.postExtractionExecutorService = Executors.newFixedThreadPool(this.MAX_POST_EXTRACTION_PARALLELISM, new ThreadFactoryBuilder().setNameFormat("embed-documents-rule-applier-post-extraction-%d").build());
    }

    public void handleLoadedDocument(InputRefs.ManagedFolderDocumentRefWithMetadata document, @Nullable HashMap<String, String> additionalDocumentProperties, EmbedDocumentsIndexer indexer, IndexerComputationResult indexerResult, ExtractedDataWriter extractedDataWriter) {
        DocExtractionRule matchedRule = this.findFirstMatchingRule(document, additionalDocumentProperties);
        EmbedDocumentsIndexer.SingleDocumentIndexerResult singleDocumentIndexerResult = indexer.indexDocument(document, matchedRule, indexerResult);
        if (singleDocumentIndexerResult.equals((Object)EmbedDocumentsIndexer.SingleDocumentIndexerResult.IS_NEW) || singleDocumentIndexerResult.equals((Object)EmbedDocumentsIndexer.SingleDocumentIndexerResult.IS_KNOWN_TO_REPROCESS)) {
            this.documentsExtractionTaskList.add(this.runRule(document, matchedRule, extractedDataWriter));
        } else {
            logger.info((Object)this.buildMessageLogForDocument(document.documentRef, "Not extracting document (Document already extracted, not modified nor matching a forced-extraction rule)"));
        }
    }

    public void onExtractionEnd(EmbedDocumentsIndexer indexer, IndexerComputationResult indexerResult) {
        CompletableFuture.allOf(this.documentsExtractionTaskList.toArray(new CompletableFuture[0])).join();
        logger.info((Object)("'all other documents' rule was applied to these " + this.unmatchedDocuments.size() + " documents: " + String.valueOf(this.unmatchedDocuments)));
        if (!this.processingFailedDocuments.isEmpty()) {
            logger.warn((Object)(this.processingFailedDocuments.size() + " documents failed to be processed and have been skipped: " + String.valueOf(this.processingFailedDocuments)));
        } else {
            logger.info((Object)"No document failed to be processed.");
        }
        indexer.stopIndexing(indexerResult);
        this.extractionExecutorService.shutdown();
        this.postExtractionExecutorService.shutdown();
    }

    public CompletableFuture<Void> runRule(InputRefs.ManagedFolderDocumentRefWithMetadata document, DocExtractionRule ruleToApply, ExtractedDataWriter extractedDataWriter) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return this.applyRule(ruleToApply, document.documentRef);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.extractionExecutorService).thenAcceptAsync(extractedData -> {
            if (extractedData != null) {
                try {
                    extractedDataWriter.writeAppendAndAccumulate(document, (ExtractedData)extractedData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Executor)this.postExtractionExecutorService)).exceptionallyAsync(e -> {
            this.processingFailedDocuments.add(document.documentRef.filePath);
            logger.error((Object)this.buildMessageLogForDocument(document.documentRef, "Document failed to be processed and was skipped"), e);
            this.activity.warnContext.addWarning(WarningsContext.WarningType.DOCUMENT_PROCESSING_FAILED, "Document " + document.documentRef.filePath + " failed to be processed and was skipped", e, logger);
            return null;
        }, (Executor)this.postExtractionExecutorService);
    }

    public DocExtractionRule findFirstMatchingRule(InputRefs.ManagedFolderDocumentRefWithMetadata document, @Nullable Map<String, String> additionalDocumentProperties) {
        String fileName = (String)PathUtils.splitBasename((String)document.documentRef.filePath).second;
        logger.info((Object)this.buildMessageLogForDocument(document, "Searching a matching rule"));
        RawObservation rawObservation = new RawObservation(new HashMap<String, String>(Map.of("file extension", FilenameUtils.getExtension((String)fileName), "file name", fileName, "file path", document.documentRef.filePath)));
        if (additionalDocumentProperties != null) {
            additionalDocumentProperties.forEach((arg_0, arg_1) -> ((RawObservation)rawObservation).put(arg_0, arg_1));
        }
        ReadOnlyRowObservation observation = new ReadOnlyRowObservation(rawObservation);
        String[] filtersColumns = rawObservation.keys().toArray(new String[0]);
        for (DocExtractionRule rule : this.rules) {
            Expression expression;
            try {
                expression = new Expression(FilterDescUtils.getGrelExpression(rule.filter));
                expression.setColumnFactory((ColumnFactory)new ReadOnlyColumnFactory(filtersColumns));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!expression.isTrueish(observation)) continue;
            logger.info((Object)this.buildMessageLogForDocument(document, "Found a matching rule : " + String.valueOf((Object)rule.actionToPerform)));
            return rule;
        }
        logger.info((Object)this.buildMessageLogForDocument(document, "No rule matched, applying the 'all other documents' rule"));
        this.unmatchedDocuments.add(document.documentRef.filePath);
        return this.allOtherFilesRule;
    }

    private ExtractedData applyRule(DocExtractionRule ruleToApply, InputRefs.ManagedFolderDocumentRef document) throws Exception {
        ExtractedData extractedData;
        switch (ruleToApply.actionToPerform) {
            case VLM: {
                extractedData = this.applyVLMRule(ruleToApply, document);
                break;
            }
            case STRUCTURED: {
                extractedData = this.applyStructuredRule(ruleToApply, document);
                break;
            }
            case DONOTEXTRACT: {
                logger.info((Object)this.buildMessageLogForDocument(document, "Not extracting document (matching an 'ignore' rule)"));
                return null;
            }
            default: {
                throw new RuntimeException("Unknown extractor");
            }
        }
        logger.info((Object)this.buildMessageLogForDocument(document, "Document extracted in " + extractedData.chunks.size() + " chunks"));
        if (this.splittingAllowed) {
            boolean usePostChunkingValuesForMultimodalCol = ruleToApply.storeInMultimodalColumn.equals((Object)DocExtractionRule.MultimodalContentType.FULL_CONTENT) || ruleToApply.storeInMultimodalColumn.equals((Object)DocExtractionRule.MultimodalContentType.CHUNKED_PROMPT_OUTPUT);
            logger.info((Object)this.buildMessageLogForDocument(document, "Performing splitting on embedded chunks (using " + (usePostChunkingValuesForMultimodalCol ? "chunked" : "un-chunked") + " values for content stored for retrieval)"));
            extractedData = this.splitExtractedData(extractedData, ruleToApply.splittingSettings, usePostChunkingValuesForMultimodalCol);
            logger.info((Object)this.buildMessageLogForDocument(document, "Splitting expanded the document into " + extractedData.chunks.size() + " records to embed"));
        }
        return extractedData;
    }

    private ExtractedData applyStructuredRule(DocExtractionRule ruleToApply, InputRefs.ManagedFolderDocumentRef document) throws Exception {
        FlowRecipe recipe = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getRecipe();
        StructuredExtractor.StructuredExtractorSettings structuredSettings = ruleToApply.structuredSettings.toStructuredExtractorSettings(this.embeddingModelRef, recipe.getModel().dkuProperties);
        if (this.isImagesStorageRequired(structuredSettings)) {
            if (this.assetsOutputFolder == null) {
                throw new Exception("Missing an output managed folder: deactivate images storage or add an output folder to the recipe");
            }
            structuredSettings.vlmAnnotationSettings.outputManagedFolderId = this.assetsOutputFolder.getFullId();
        }
        long structuredStartTime = System.currentTimeMillis();
        StructuredExtractorResponseOrError structuredResp = this.runStructuredInBackend(this.projectKey, structuredSettings, document);
        long structuredProcessingTime = System.currentTimeMillis() - structuredStartTime;
        if (!structuredResp.ok) {
            logger.error((Object)this.buildMessageLogForDocument(document, "Got structured extraction result: failed - " + structuredResp.errorMessage + " (processing time: " + structuredProcessingTime + "ms)"));
            throw new Exception(structuredResp.errorMessage);
        }
        logger.info((Object)this.buildMessageLogForDocument(document, "Got structured extraction result: success (processing time: " + structuredProcessingTime + "ms)"));
        ExtractedData extractedData = new ExtractedData(ExtractedData.ExtractorEngine.STRUCTURED, document);
        if (this.isImagesStorageRequired(structuredSettings)) {
            structuredSettings.vlmAnnotationSettings.outputManagedFolderId = this.assetsOutputFolder.getFullId();
            ruleToApply.storeInMultimodalColumn = DocExtractionRule.MultimodalContentType.IMAGES;
            for (StructuredExtractionChunk chunk2 : structuredResp.chunks) {
                extractedData.assetsStoragePath = chunk2.getImagesCommonPrefixPath();
                if (extractedData.assetsStoragePath == null) continue;
                break;
            }
        }
        List<StructuredRuleChunk> chunks = structuredResp.chunks.stream().map(chunk -> StructuredRuleChunk.buildFromExtractionChunk(chunk)).toList();
        List<StructuredRuleChunk> filteredChunks = StructuredRuleChunk.skipEmptySectionsAndPrependOutlineIfNeeded(chunks, this.prependFullOutlineToEachChunksPriorSplitting);
        extractedData.createFromRuleChunks(filteredChunks.stream().map(c2 -> c2).collect(Collectors.toList()));
        return extractedData;
    }

    private boolean isScreenshotStorageRequired(DocExtractionRule ruleToApply) {
        return this.alwaysStoreScreenshots != null ? this.alwaysStoreScreenshots.booleanValue() : ruleToApply.storeInMultimodalColumn.equals((Object)DocExtractionRule.MultimodalContentType.IMAGES);
    }

    private boolean isImagesStorageRequired(StructuredExtractor.StructuredExtractorSettings structuredSettings) {
        return structuredSettings.imageHandlingMode == StructuredExtractor.ImageHandlingMode.VLM_ANNOTATE && this.storeOriginalImages != false;
    }

    private ExtractedData applyVLMRule(DocExtractionRule ruleToApply, InputRefs.ManagedFolderDocumentRef document) throws Exception {
        Screenshotter.ScreenshotterResponseOrError screenshotterResponse;
        Screenshotter.ScreenshotterSettings screenshotterSettings = new Screenshotter.ScreenshotterSettings();
        screenshotterSettings.paginationSize = this.DEFAULT_PAGINATION_SIZE;
        screenshotterSettings.paginationOffset = 0;
        VLMExtractor.VLMExtractorSettings vlmSettings = ruleToApply.vlmSettings.toVLMExtractorSettings(this.embeddingModelRef);
        ExtractedData extractedData = new ExtractedData(ExtractedData.ExtractorEngine.VLM, document);
        ArrayList<VlmRuleChunk.PrimitiveChunk> computedChunks = new ArrayList<VlmRuleChunk.PrimitiveChunk>();
        if (this.isScreenshotStorageRequired(ruleToApply)) {
            if (this.assetsOutputFolder == null) {
                throw new Exception("Missing an output managed folder: deactivate screenshots storage or add an output folder to the recipe");
            }
            screenshotterSettings.outputManagedFolderId = this.assetsOutputFolder.getFullId();
        }
        do {
            long screenshotterStartTime = System.currentTimeMillis();
            screenshotterResponse = this.screenshotterService.extractScreenshotsFromManagedFolderDocumentRef(this.authCtx, this.projectKey, document, screenshotterSettings);
            long screenshotterProcessingTime = System.currentTimeMillis() - screenshotterStartTime;
            if (!screenshotterResponse.ok) {
                logger.error((Object)this.buildMessageLogForDocument(document, "Got screenshotter result: failed - " + screenshotterResponse.errorMessage + " (processing time: " + screenshotterProcessingTime + "ms)"));
                throw new Exception(screenshotterResponse.errorMessage);
            }
            logger.info((Object)this.buildMessageLogForDocument(document, "Got screenshotter result: success (processing time: " + screenshotterProcessingTime + "ms)"));
            int lastPaginationOffset = screenshotterSettings.paginationOffset;
            if (screenshotterResponse.hasMoreResults) {
                screenshotterSettings.paginationOffset = screenshotterResponse.lastResultIndex + 1;
            }
            if (this.isScreenshotStorageRequired(ruleToApply)) {
                if (!(screenshotterResponse.imagesRefs instanceof InputRefs.ManagedFolderImagesRef)) {
                    throw new Exception("Screenshotter returned an image ref that is not a managed folder");
                }
                extractedData.assetsStoragePath = ((InputRefs.ManagedFolderImagesRef)screenshotterResponse.imagesRefs).commonPrefixPath;
            }
            long vlmExtractionStartTime = System.currentTimeMillis();
            VlmExtractorResponseOrError vlmExtractionResp = this.runVLMInBackend(this.projectKey, new VLMExtractor.VLMExtractorRequest(screenshotterResponse.imagesRefs, vlmSettings), document);
            long vlmExtractionProcessingTime = System.currentTimeMillis() - vlmExtractionStartTime;
            if (!vlmExtractionResp.ok) {
                logger.error((Object)this.buildMessageLogForDocument(document, "Got VLM extraction result: failed - " + vlmExtractionResp.errorMessage + " (processing time: " + vlmExtractionProcessingTime + "ms)"));
                throw new Exception(vlmExtractionResp.errorMessage);
            }
            logger.info((Object)this.buildMessageLogForDocument(document, "Got VLM extraction result: success (processing time: " + vlmExtractionProcessingTime + "ms)"));
            logger.info((Object)(document.filePath + ": " + (screenshotterResponse.lastResultIndex + 1) + " processed pages over " + screenshotterResponse.totalResults + " total pages."));
            computedChunks.addAll(vlmExtractionResp.chunks.stream().map(chunk -> VlmRuleChunk.PrimitiveChunk.buildFromExtractionChunk(chunk, lastPaginationOffset)).toList());
        } while (screenshotterResponse.hasMoreResults);
        if (vlmSettings.aggregateResults) {
            extractedData.createFromRuleChunks(Collections.singletonList(new VlmRuleChunk.DocumentChunk(computedChunks)));
        } else {
            extractedData.createFromRuleChunks(computedChunks.stream().map(c2 -> c2).collect(Collectors.toList()));
        }
        return extractedData;
    }

    private ExtractedData splitExtractedData(ExtractedData extractedData, DocExtractionRule.SplittingSettings splittingSettings, boolean usePostChunkingValuesForMultimodalCol) {
        RecursiveCharacterTextSplitter.Parameter param = new RecursiveCharacterTextSplitter.Parameter();
        param.chunkSize = splittingSettings.chunkSizeCharacters;
        param.chunkOverlap = splittingSettings.chunkOverlapCharacters;
        param.validate();
        RecursiveCharacterTextSplitter splitter = new RecursiveCharacterTextSplitter(param);
        ExtractedData splitExtractedData = new ExtractedData(extractedData.extractorEngine, extractedData.sourceDocument);
        if (extractedData != null) {
            splitExtractedData.assetsStoragePath = extractedData.assetsStoragePath;
            for (SingleExtractedChunk chunk : extractedData.chunks) {
                List<String> embedValues = splitter.splitText(chunk.embedValue);
                if (usePostChunkingValuesForMultimodalCol) {
                    splitExtractedData.createChunks(embedValues, embedValues.stream().map(MultimodalTextPart::new).collect(Collectors.toList()), Collections.nCopies(embedValues.size(), chunk.extractedMetadata), Collections.nCopies(embedValues.size(), chunk.json));
                    continue;
                }
                splitExtractedData.createChunks(embedValues, Collections.nCopies(embedValues.size(), chunk.multimodalPart), Collections.nCopies(embedValues.size(), chunk.extractedMetadata), Collections.nCopies(embedValues.size(), chunk.json));
            }
        }
        return splitExtractedData;
    }

    private VlmExtractorResponseOrError runVLMInBackend(String projectKey, VLMExtractor.VLMExtractorRequest vlmRequest, InputRefs.ManagedFolderDocumentRef document) {
        VlmExtractorResponseOrError vlmExtractorResponseOrError;
        block8: {
            String secret = this.ticketService.getSingleTicket().getSecret();
            TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);
            try {
                String areImgInlined = vlmRequest.inputs.imagesRef instanceof InputRefs.InlineImagesRef ? "inlined" : "stored";
                logger.info((Object)this.buildMessageLogForDocument(document, "Calling VLM extractor on " + areImgInlined + " screenshots with settings: " + vlmRequest.settings.toString()));
                vlmExtractorResponseOrError = (VlmExtractorResponseOrError)tClient.postFormToJSON("/dip/api/tintercom/docextraction/vlm", VlmExtractorResponseOrError.class, new Object[]{"projectKey", projectKey, "vlmRequest", JSON.json((Object)vlmRequest), "jobId", JobContext.getCurrentJobContext().jobId, "activity", JobContext.getCurrentJobContext().activity});
                if (tClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tClient != null) {
                        try {
                            tClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            tClient.close();
        }
        return vlmExtractorResponseOrError;
    }

    private StructuredExtractorResponseOrError runStructuredInBackend(String projectKey, StructuredExtractor.StructuredExtractorSettings settings, InputRefs.ManagedFolderDocumentRef documentRef) {
        StructuredExtractorResponseOrError structuredExtractorResponseOrError;
        block8: {
            String secret = this.ticketService.getSingleTicket().getSecret();
            TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);
            try {
                logger.info((Object)this.buildMessageLogForDocument(documentRef, "Calling Structured extractor with settings: " + settings.toString()));
                structuredExtractorResponseOrError = (StructuredExtractorResponseOrError)tClient.postFormToJSON("/dip/api/tintercom/docextraction/structured-flatten", StructuredExtractorResponseOrError.class, new Object[]{"projectKey", projectKey, "settings", JSON.json((Object)settings), "documentRef", JSON.json((Object)documentRef), "useSeparatedChunksForImages", this.useSeparatedChunksForImages, "jobId", JobContext.getCurrentJobContext().jobId, "activity", JobContext.getCurrentJobContext().activity});
                if (tClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tClient != null) {
                        try {
                            tClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            tClient.close();
        }
        return structuredExtractorResponseOrError;
    }

    public String buildMessageLogForDocument(InputRefs.ManagedFolderDocumentRef documentRef, String message) {
        return String.format("[%s] - %s", documentRef.filePath, message);
    }

    public String buildMessageLogForDocument(InputRefs.ManagedFolderDocumentRefWithMetadata document, String message) {
        return this.buildMessageLogForDocument(document.documentRef, message);
    }
}

