/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.extract_content;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractContentRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractedDataDatasetWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtractContentRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    private ExtractContentRecipePayloadParams desc;

    public ExtractContentRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (ExtractContentRecipePayloadParams)JSON.parse((String)payload, ExtractContentRecipePayloadParams.class);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        Preconditions.checkArgument((boolean)ArrayUtils.contains((Object[])new String[]{"main", "images"}, (Object)role), (Object)("Recipe only has output roles 'main' or 'images', got: " + role));
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            if (role.equals("images") && this.recipe.getOutputsForRole(role).isEmpty()) {
                ArrayList arrayList = Lists.newArrayList();
                return arrayList;
            }
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getMainOutputSchema()});
            return arrayList;
        }
    }

    public Schema getMainOutputSchema() {
        return ExtractedDataDatasetWriter.getMainOutputSchema();
    }
}

