/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.utils.DKULogger;

public abstract class AbstractShakerRecipeSQLRunner
implements RecipeRunner,
AbortableRecipeRunner,
RecipeRunnerWithPayload {
    protected final JobActivity activity;
    protected final FlowRecipe recipe;
    private AbortableRecipeRunner runner;
    private volatile boolean abortNotified;
    AbstractSqlQueryWithSchemaBuilder sqlQueryWithSchemaBuilder;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.shaker.sql");

    AbstractShakerRecipeSQLRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
    }

    protected abstract String getEngineType();

    protected abstract AbortableRecipeRunner buildRecipeRunner(ShakerSQLTranslator.TranslatorResult var1) throws Exception;

    @Override
    public void setPayload(String payload) {
        logger.infoV("SET PAYLOAD '%s' for engine %s", new Object[]{payload, this.getEngineType()});
        this.sqlQueryWithSchemaBuilder.setPayload(payload);
    }

    @Override
    public void init() throws Exception {
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        this.sqlQueryWithSchemaBuilder.init();
    }

    @Override
    public void run() throws Exception {
        this.runner = this.buildRecipeRunner(this.sqlQueryWithSchemaBuilder.build());
        if (this.abortNotified) {
            logger.info((Object)"Abort already notified, skipping run");
            return;
        }
        this.runner.run();
    }

    @Override
    public void notifyBeforeAborting() {
        this.abortNotified = true;
        AbortableRecipeRunner runner = this.runner;
        if (runner != null) {
            runner.notifyBeforeAborting();
        }
    }
}

