/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.reports;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.reports.RMarkdownReportRunner;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportSnapshot;
import com.dataiku.dip.reports.ReportTemplateDesc;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.reports.ReportsSnapshotsService;
import com.dataiku.dip.reports.ReportsTemplateService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportsService {
    @Autowired
    private ReportsDAO dao;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ReportsSnapshotsService reportsExportService;
    @Autowired
    private ReportsTemplateService templatesService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.reports.service");

    public List<Report> listUnsafe(String projectKey) throws IOException {
        return this.dao.listUnsafe(projectKey);
    }

    public Report getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (Report)this.dao.getOrNullUnsafe(projectKey, id);
    }

    public Report getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (Report)this.dao.getMandatoryUnsafe(projectKey, id);
    }

    public Report getOrNull(String projectKey, String id) throws IOException {
        return (Report)this.dao.getOrNull(projectKey, id);
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.dao.approximateCount(projectKey);
    }

    public List<Report.ReportListItem> listHeads(String projectKey) throws IOException {
        ArrayList<Report.ReportListItem> ret = new ArrayList<Report.ReportListItem>();
        for (Report report : this.dao.listUnsafe(projectKey)) {
            Report.ReportListItem listItem = new Report.ReportListItem(report);
            this.taggableObjectsService.setEditionInfoFromTags(report, listItem);
            ret.add(listItem);
        }
        return ret;
    }

    public ReportWithScript create(String projectKey, String name, ReportTemplateDesc templateDesc) throws Exception {
        String id;
        while (this.dao.getOrNullUnsafe(projectKey, id = SecretKeyGenerator.generateSmall()) != null) {
        }
        Report report = new Report();
        report.id = id;
        report.projectKey = projectKey;
        report.name = name;
        report.params = new Report.ReportParams();
        report.params.buildOnSave = true;
        File templateFolder = this.templatesService.getTemplateDir(templateDesc.type, templateDesc);
        String script = this.initReport(templateDesc.id, templateFolder);
        this.save(report, script, true);
        return new ReportWithScript(report, script);
    }

    public Report save(Report report, String script, boolean creation) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)report.params, (Object)"Report params are required");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.getUser().failIfNoSafeCode("save a code report");
        Report existing = (Report)this.dao.getOrNullUnsafe(report.projectKey, report.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(report, existing);
        if (creation) {
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(report);
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(report.projectKey, report.id), report);
        this.dao.save(report, script);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", report.name);
        if (creation) {
            action = TaggableObjectChangedEvent.ActionType.REPORT_CREATE;
        } else if (report.name != null && existing != null && !report.name.equals(existing.name)) {
            action = TaggableObjectChangedEvent.ActionType.REPORT_RENAME;
            details.addProperty("newName", report.name);
            details.addProperty("oldName", existing.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.REPORT_EDIT;
            TaggableObjectDiffService.addTagEditInfoIfNeeded(existing, report, details);
        }
        this.taggingService.onObjectSaved(report.projectKey, report.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.REPORT, report.projectKey, report.id, t.getUser(), action).withDetails(details));
        return report;
    }

    public void delete(AuthCtx authCtx, String projectKey, String id) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        JsonObject details = new JsonObject();
        Report wa = (Report)this.dao.getOrNull(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, wa);
        if (wa != null) {
            details.addProperty("objectDisplayName", wa.name);
        }
        this.deleteBuildFiles(projectKey, id);
        this.reportsExportService.deleteForReport(projectKey, id);
        this.dao.delete(projectKey, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.REPORT, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.REPORT_DELETE).withDetails(details));
    }

    public Report copy(String projectKey, String id, String newName) throws Exception {
        Report report = (Report)this.dao.getMandatory(projectKey, id);
        String script = this.dao.getPayloadOrNull(projectKey, id);
        newName = StringUtils.isBlank((String)newName) ? report.name : newName;
        Preconditions.checkArgument((report.projectKey != null ? 1 : 0) != 0, (Object)"Original report has no project key");
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", newName);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.REPORT_CREATE;
        details.addProperty("copy", Boolean.valueOf(true));
        details.addProperty("originalObjectName", report.name);
        details.addProperty("originalObjectId", report.id);
        AuthCtx user = TransactionContext.retrieveWrite().getUser();
        report.id = SecretKeyGenerator.generateSmall();
        report.name = newName;
        report.creationTag = report.versionTag = VersionTag.increment(null, user.getIdentifier());
        this.customPolicyHooksRegistry.onPreObjectSave(user, null, report);
        this.dao.save(report, script);
        this.taggingService.onObjectSaved(report.projectKey, report.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.REPORT, report.projectKey, report.id, user, action).withDetails(details));
        return report;
    }

    public void deleteForProject(String projectKey) {
        try {
            File folder = this.getProjectReportsBuildFolder(projectKey);
            if (folder.exists()) {
                DKUFileUtils.forceDelete((File)folder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete built rmarkdown reports", (Throwable)e);
        }
    }

    public void deleteBuildFiles(String projectKey, String id) {
        try {
            File file = this.getReportBuildFolder(projectKey, id);
            if (file.exists()) {
                DKUFileUtils.forceDelete((File)file);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete built rmarkdown report", (Throwable)e);
        }
    }

    public FutureResponse<RMarkdownReportRunner.ReportBuildResponse> build_NT(Report report, String script, AuthCtx authCtx) throws Exception {
        ReportSingleFormatBuildFutureThread ft = this.makePreviewThread(report, script, authCtx);
        return this.futureService.runFuture(ft, 10000L, new TypeToken<FutureResponse<RMarkdownReportRunner.ReportBuildResponse>>(){});
    }

    public RMarkdownReportRunner.ReportBuildResponse buildSync_NT(Report report, String script, AuthCtx authCtx) throws Exception {
        ReportSingleFormatBuildFutureThread ft = this.makePreviewThread(report, script, authCtx);
        return (RMarkdownReportRunner.ReportBuildResponse)this.futureService.runAndWait(ft, (TypeToken)new TypeToken<FutureResponse<RMarkdownReportRunner.ReportBuildResponse>>(){});
    }

    public FutureResponse<RMarkdownReportRunner.ReportBuildResponse> startDownload_NT(AuthCtx authCtx, Report report, String script, Report.ReportOutputFormat format, boolean useLatestSnapshotIfItContainsFormat, File forcedOutputFile) throws Exception {
        List<ReportSnapshot> snapshots;
        File outputFile;
        logger.infoV("Starting download of report %s.%s (format=%s mayUseLatestSnapshot=%s)", new Object[]{report.projectKey, report.id, format, useLatestSnapshotIfItContainsFormat});
        File file = outputFile = forcedOutputFile == null ? this.getSingleReportDownloadFile(report, format) : forcedOutputFile;
        if (useLatestSnapshotIfItContainsFormat && (snapshots = this.reportsExportService.listSorted_NT(report.projectKey, report.id)).size() > 0) {
            ReportSnapshot firstSnapshot = snapshots.get(0);
            if (firstSnapshot.availableFormats.contains((Object)format)) {
                logger.infoV("First snapshot (%s) contains format %s, using it", new Object[]{firstSnapshot.timestamp, format});
                return this.futureService.runFuture(new ReportSnapshotCopyThread(firstSnapshot, format, outputFile, authCtx), 1000L, new TypeToken<FutureResponse<RMarkdownReportRunner.ReportBuildResponse>>(){});
            }
        }
        logger.info((Object)"Could not use latest snapshot (either disallowed or not usable), building the download directly");
        return this.futureService.runFuture(new ReportSingleFormatBuildFutureThread(report, script, format, outputFile, authCtx), 1000L, new TypeToken<FutureResponse<RMarkdownReportRunner.ReportBuildResponse>>(){});
    }

    public String getScript(String projectKey, String id) throws IOException {
        return this.dao.getPayloadOrNull(projectKey, id);
    }

    public File getReportViewFile(Report report) {
        return DKUFileUtils.getWithin((File)this.getReportBuildFolder(report), (String[])new String[]{report.id + "." + report.params.viewFormat.getExtension()});
    }

    public File newReportDownloadTempFile(Report report, Report.ReportOutputFormat downloadFormat) {
        return DSSTempUtils.getTempFileNoCreate((String)"code-reports-downloads", (String)(report.projectKey + "." + report.id + "." + String.valueOf((Object)downloadFormat)), (String)downloadFormat.getExtension());
    }

    public File getSingleReportDownloadFile(Report report, Report.ReportOutputFormat downloadFormat) throws IOException {
        return DSSTempUtils.getTempFileWithSpecificName((String)"code-reports-downloads", (String)(report.projectKey + "." + report.id + "." + String.valueOf((Object)downloadFormat) + "_main"), (String)downloadFormat.getExtension());
    }

    private String initReport(String templateId, File templateFolder) throws IOException {
        String script = "";
        if (StringUtils.isNotBlank((String)templateId)) {
            File scriptFile = new File(templateFolder, "script.Rmd");
            if (scriptFile.exists()) {
                script = DKUFileUtils.readFileToStringUTF8((File)scriptFile);
            } else {
                logger.info((Object)("Empty report template: " + templateId));
            }
        }
        return script;
    }

    private File getReportBuildFolder(Report report) {
        return this.getReportBuildFolder(report.projectKey, report.id);
    }

    private File getReportBuildFolder(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Report id not specified");
        return DKUFileUtils.getWithin((File)this.getProjectReportsBuildFolder(projectKey), (String[])new String[]{id});
    }

    private File getProjectReportsBuildFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Report projectKey not specified");
        return ApplicationConfigurator.getFile((String[])new String[]{"code-reports", projectKey});
    }

    private ReportSingleFormatBuildFutureThread makePreviewThread(Report report, String script, AuthCtx authCtx) {
        logger.info((Object)("Build report " + report.name + "(" + report.getFullId() + ")"));
        Report.ReportOutputFormat format = report.params.viewFormat;
        File outputFile = this.getReportViewFile(report);
        return new ReportSingleFormatBuildFutureThread(report, script, format, outputFile, authCtx);
    }

    public static class ReportWithScript {
        public Report report;
        public String script;

        public ReportWithScript(Report report, String script) {
            this.report = report;
            this.script = script;
        }
    }

    private static class ReportSingleFormatBuildFutureThread
    extends SimpleFutureThread<RMarkdownReportRunner.ReportBuildResponse> {
        private Report report;
        private String script;
        private Report.ReportOutputFormat format;
        private File outputFile;
        private DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();

        ReportSingleFormatBuildFutureThread(Report report, String script, Report.ReportOutputFormat format, File outputFile, AuthCtx owner) {
            super(owner);
            this.report = report;
            this.script = script;
            this.format = format;
            this.outputFile = outputFile;
        }

        public SmartLogTail getLog() {
            return this.smartLogTailBuilder.get();
        }

        public FuturePayload getPayload() {
            FuturePayload ret = new FuturePayload();
            ret.targets = Lists.newArrayList((Object[])new FuturePayload.FuturePayloadTarget[]{DSSFuturePayloadUtils.forTaggableObject(this.report)});
            ret.displayName = "Build report";
            ret.action = "BUILD_REPORT";
            return ret;
        }

        @Override
        public RMarkdownReportRunner.ReportBuildResponse compute() throws Exception {
            RMarkdownReportRunner builder = new RMarkdownReportRunner(this.report, this.script, this.format, this.outputFile, this.owner);
            return builder.build(this.smartLogTailBuilder);
        }
    }

    private class ReportSnapshotCopyThread
    extends SimpleFutureThread<RMarkdownReportRunner.ReportBuildResponse> {
        private ReportSnapshot snapshot;
        private Report.ReportOutputFormat format;
        private File outputFile;

        public ReportSnapshotCopyThread(ReportSnapshot snapshot, Report.ReportOutputFormat format, File outputFile, AuthCtx authCtx) {
            super(authCtx);
            this.snapshot = snapshot;
            this.format = format;
            this.outputFile = outputFile;
        }

        @Override
        protected RMarkdownReportRunner.ReportBuildResponse compute() throws Exception {
            RMarkdownReportRunner.ReportBuildResponse ret = new RMarkdownReportRunner.ReportBuildResponse();
            try {
                File snapshotFile = ReportsService.this.reportsExportService.getSnapshotOutputFile(this.snapshot, this.format);
                FileUtils.copyFile((File)snapshotFile, (File)this.outputFile);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to copy report", (Throwable)e);
                throw e;
            }
            return ret;
        }

        public FuturePayload getPayload() {
            FuturePayload ret = new FuturePayload();
            ret.displayName = "Copy report for download";
            ret.action = "BUILD_REPORT";
            return ret;
        }
    }
}

