/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.ContainerExecImagesBuilder;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
class ContainerExecInformation {
    ContainerExecInformation() {
    }

    List<BaseImageIdAndType> computeBaseImageIdAndType(CodeEnvModel.AbstractEnvDesc envDesc, String envName) throws IOException {
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        return ContainerExecImagesBuilder.computeContainerBaseConfigs(envDesc, envName, infoMessages).stream().map(containerBaseConfig -> new BaseImageIdAndType(Optional.ofNullable(containerBaseConfig.baseImage).filter(customBaseImage -> !customBaseImage.isBlank()).orElse(ContainerExecImagesHelper.getDefaultBaseImageTag(containerBaseConfig.baseImageType)), containerBaseConfig.baseImageType)).collect(Collectors.toList());
    }

    Optional<String> getImageTag(ContainerExecUtils.BaseImageType baseImageType, CodeEnvModel.EnvLang envLang, String envName, @Nullable String envVersion) throws IOException {
        try {
            return Optional.of(ContainerExecImagesHelper.getImageTag(false, null, null, baseImageType, envLang, envName, envVersion).getFullTag());
        }
        catch (CodedIOException e) {
            return Optional.empty();
        }
    }

    ContainerSettings getGlobalContainerSettings() throws IOException {
        return new ClusterSelector().selectGlobal().getContainerSettings();
    }

    static class BaseImageIdAndType {
        final String baseImageId;
        final ContainerExecUtils.BaseImageType baseImageType;

        BaseImageIdAndType(String baseImageId, ContainerExecUtils.BaseImageType baseImageType) {
            this.baseImageId = baseImageId;
            this.baseImageType = baseImageType;
        }
    }
}

