/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuntimeDatabaseDetector
implements SanityCheckDetectorBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.runtimedatabasedetector");

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (!exclusionList.contains(Codes.WARN_MISC_LARGE_INTERNAL_DB.getCode())) {
            try {
                File[] databases;
                GeneralSettingsDAO.GeneralSettings generalSettings;
                try (Transaction read = this.transactionService.beginRead();){
                    generalSettings = this.generalSettingsDAO.getUnsafe();
                }
                if (generalSettings.internalDatabase.connection == null && (databases = new File(DKUApp.getBaseFolderF(), "databases").listFiles()) != null) {
                    int sizeThreshold = DKUApp.getParams().getIntParam("dku.sanitycheck.runtimedb.internal_db_threshold_gb", Integer.valueOf(5));
                    Arrays.stream(databases).filter(file -> file.length() > (long)sizeThreshold * 1024L * 1024L * 1024L).forEach(database -> messages.withTrustedHTMLV(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_MISC_LARGE_INTERNAL_DB, "Internal runtime database '%s' exceeds %sGB, it is recommended to switch to <a href=\"https://doc.dataiku.com/dss/latest/operations/runtime-databases.html#externally-hosting-runtime-databases\" target=\"_blank\">external runtime database</a>.", new String[]{database.getName(), Integer.toString(sizeThreshold)}));
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Sanity check failed", (Throwable)e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        return messages;
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_MISC_LARGE_INTERNAL_DB("Runtime database - Large internal database", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

