/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.utils.DKULogger;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UIFDetector
implements SanityCheckDetectorBase {
    @Autowired
    private IImpersonationResolverService impersonationService;
    public static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.uifdetector");

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (!exclusionList.contains(Codes.WARN_SECURITY_UIF_NOT_ENABLED.getCode())) {
            logger.debug((Object)"check UIF enablement");
            if (!this.impersonationService.isEnabled()) {
                messages.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_SECURITY_UIF_NOT_ENABLED, "User Isolation is not enabled. See <a href=\"https://doc.dataiku.com/dss/12/user-isolation/index.html\" target=\"_blank\">the documentation</a> for more details."));
            }
        }
        return messages;
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_SECURITY_UIF_NOT_ENABLED("Security - User Isolation Framework (UIF) not enabled", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

