/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.DSSRunnable;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableMeta;
import com.dataiku.dip.scheduler.runnables.JavaDSSRunnable;
import com.dataiku.dip.scheduler.runnables.JavaRunnableDesc;
import com.dataiku.dip.scheduler.runnables.LoadedJavaRunnable;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JavaRunnableMeta
implements DSSRunnableMeta {
    private final LoadedJavaRunnable loaded;

    public JavaRunnableMeta(LoadedJavaRunnable loaded, CustomJavaRunnablesService javaRunnablesService) {
        this.loaded = loaded;
    }

    @Override
    public String getType() {
        return this.loaded.getType();
    }

    @Override
    public String getLabel() {
        if (((JavaRunnableDesc)this.loaded.desc).meta != null && StringUtils.isNotBlank((String)((JavaRunnableDesc)this.loaded.desc).meta.label)) {
            return ((JavaRunnableDesc)this.loaded.desc).meta.label;
        }
        return this.loaded.runnableType;
    }

    @Override
    public DSSRunnable buildRunnable(AuthCtx authCtx, String projectKey, JsonObject params) {
        JavaDSSRunnable runnable = new JavaDSSRunnable(authCtx, projectKey, this.loaded, params);
        SpringUtils.getInstance().autowire((Object)runnable);
        return runnable;
    }

    @Override
    public boolean runOutOfCore() {
        return ((JavaRunnableDesc)this.loaded.desc).canOomJvm;
    }

    @Override
    public List<ParamDesc> getParams() {
        ArrayList allParams = Lists.newArrayList();
        allParams.addAll(((JavaRunnableDesc)this.loaded.desc).adminParams);
        allParams.addAll(((JavaRunnableDesc)this.loaded.desc).params);
        return allParams;
    }

    @Override
    public LoadedRunnable<? extends DSSRunnableDesc> getLoadedDesc() {
        return this.loaded;
    }
}

