/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.scheduler.model.FlowItemsToCompare;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.scheduler.utils.FlowTestUtils;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;

public class CompareTestDatasetsStepRunner
implements StepRunner {
    private final Scenario scenario;
    private final CompareTestDatasetsStepParams params;
    private final Step step;
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "compare_test_datasets";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CompareTestDatasetsStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CompareTestDatasetsStepRunner(scenario, step, step.getParamsAs(CompareTestDatasetsStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            CompareTestDatasetsStepParams stepParams = step.getParamsAs(CompareTestDatasetsStepParams.class);
            if (stepParams == null) {
                return "Compare test datasets";
            }
            StringBuilder sb = new StringBuilder("Compare test datasets:");
            stepParams.getCompares().stream().filter(comparison -> comparison.resultSmartName != null && comparison.expectedSmartName != null).findFirst().ifPresent(comparison -> sb.append(String.format("(%s, %s)", comparison.resultSmartName, comparison.expectedSmartName)));
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            CompareTestDatasetsStepParams stepParams = step.getParamsAs(CompareTestDatasetsStepParams.class);
            if (stepParams == null) {
                return META.getType();
            }
            StringBuilder sb = new StringBuilder(String.format("%s__", META.getType()));
            sb.append("__compare");
            stepParams.getCompares().stream().filter(comparison -> comparison.resultSmartName != null && comparison.expectedSmartName != null).findFirst().ifPresent(comparison -> sb.append(String.format("_(%s,%s)", comparison.resultSmartName, comparison.expectedSmartName)));
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.compareTestDatasetsStepRunner");

    public CompareTestDatasetsStepRunner(Scenario scenario, Step step, CompareTestDatasetsStepParams params) {
        this.scenario = scenario;
        this.params = params;
        this.step = step;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone reportItem) throws Exception {
        logger.infoV("Start step %s", new Object[]{this.step.getName()});
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        DSSAuthCtx authCtx = scenarioRun.getRunAsUser();
        String contextProjectKey = this.scenario.getProjectKey();
        FlowTestUtils.assertValidCompareParams(authCtx, this.params.getCompares(), contextProjectKey);
        logger.infoV("Will swap %d flow items with their target mapping", new Object[]{this.params.getCompares().size()});
        FlowTestUtils.compareDatasets(authCtx, this.params.getCompares(), contextProjectKey, reportItem, stepRun);
    }

    public static class CompareTestDatasetsStepParams
    extends NonFatalStepParams
    implements StepParams {
        private final List<FlowItemsToCompare> compares = Lists.newArrayList();

        @Nonnull
        public List<FlowItemsToCompare> getCompares() {
            return this.compares;
        }
    }
}

