/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class KillScenarioStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return KillScenarioStepParams.class;
        }

        @Override
        public String getType() {
            return "kill_scenario";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new KillScenarioStepRunner(scenario, step, step.getParamsAs(KillScenarioStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            KillScenarioStepParams params = step.getParamsAs(KillScenarioStepParams.class);
            return "kill scenario " + (params != null && params.scenarioId != null ? params.scenarioId : "");
        }

        @Override
        public String buildId(Step step) {
            KillScenarioStepParams params = step.getParamsAs(KillScenarioStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("kill_scenario");
            if (params != null) {
                sb.append("_");
                if (StringUtils.isBlank((String)params.getProjectKey())) {
                    sb.append(params.getProjectKey());
                    sb.append(".");
                }
                sb.append(params.getScenarioId());
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final KillScenarioStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private ScenarioRunsService scenarioRunsService;
    @Autowired
    private ProjectsService projectsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.killscenario");

    KillScenarioStepRunner(Scenario scenario, Step step, KillScenarioStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.params.getProjectKey() != null ? this.params.getProjectKey() : this.scenario.getProjectKey();
        String scenarioId = this.params.getScenarioId();
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx runAsUser = stepRun.getScenarioRun().getRunAsUser();
            this.projectsService.checkPerm(runAsUser, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Scenario scenario = this.scenariosService.getMandatory(projectKey, scenarioId);
            ScenarioThread scenarioThread = this.scenarioRunsService.getMostRecentScenarioRun(scenario);
            ScenarioKillResult result = new ScenarioKillResult();
            if (scenarioThread != null && scenarioThread.isAlive()) {
                if (scenarioThread.isAborted()) {
                    result.wasRunning = true;
                    result.alreadyAborted = true;
                } else {
                    result.wasRunning = true;
                    result.killed = true;
                    scenarioThread.abort("Aborted by step '" + stepRun.getStep().getName() + "' in scenario '" + stepRun.getScenarioRun().getScenario().getName() + "'");
                }
            }
            stepRun.payload = result;
            stepRun.getScenarioRun().withStepRunOutput(stepRun, result);
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class KillScenarioStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String projectKey;
        public String scenarioId;

        public String getProjectKey() {
            return this.projectKey;
        }

        public String getScenarioId() {
            return this.scenarioId;
        }

        public KillScenarioStepParams withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public KillScenarioStepParams withScenarioId(String scenarioId) {
            this.scenarioId = scenarioId;
            return this;
        }
    }

    public static class ScenarioKillResult {
        public boolean killed;
        public boolean wasRunning;
        public boolean alreadyAborted;
    }
}

