/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.impersonation;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;

public class ThreadLocalManualImpersonationResolverService
implements IImpersonationResolverService {
    private ThreadLocal<Settings> settings = new ThreadLocal();

    public void setSettings(boolean enabled, UserImpersonationTarget user) {
        this.settings.remove();
        Settings s = new Settings();
        s.enabled = enabled;
        s.user = user;
        this.settings.set(s);
    }

    @Override
    public boolean isEnabled() {
        if (this.settings.get() == null) {
            throw new Error("Unconfigured impersonation");
        }
        return this.settings.get().enabled;
    }

    @Override
    public UserImpersonationTarget getTargetUser(String contextProjectKey, AuthCtx authCtx) throws DKUSecurityException {
        if (this.settings.get() == null) {
            throw new Error("Unconfigured impersonation");
        }
        return this.settings.get().user;
    }

    @Override
    public boolean usesHadoopDelegationTokens() {
        return true;
    }

    private static class Settings {
        boolean enabled;
        UserImpersonationTarget user;

        private Settings() {
        }
    }
}

