/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.ExternalTable;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.ConnectionMetadataDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.SQLDatabaseMetadataRetriever;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionsDumpService {
    public static final String DATA_CATALOG = "data-catalog";
    private static final String METRICS_PREFIX = "catalog.dumpObjectsFromSqlConnection.";
    private static final String DUMPS_FOLDER = "dumps";
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ConnectionMetadataDAO connectionMetadataDAO;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.connections.dumpservice");

    public Map<String, InfoMessage.InfoMessages> scanConnectionsByName(Collection<String> connectionNames, AuthCtx authCtx) throws IOException, InterruptedException, DKUSecurityException {
        return this.scanConnections(this.connectionsDAO.getConnections(authCtx, connectionNames), authCtx);
    }

    public static String getConnectionLockName(String connectionName) {
        return "dku.catalog.external.indexing.connection." + connectionName;
    }

    public Map<String, InfoMessage.InfoMessages> scanConnections(List<DSSConnection> connections, AuthCtx ctx) throws InterruptedException {
        HashMap<String, InfoMessage.InfoMessages> messages = new HashMap<String, InfoMessage.InfoMessages>();
        Collection sqlConnections = Collections2.filter(connections, (Predicate)new Predicate<DSSConnection>(){

            public boolean apply(@Nullable DSSConnection dssConnection) {
                return ConnectionUtils.isSQLConnectionType(dssConnection.type);
            }
        });
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Scanning connections", (double)sqlConnections.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (DSSConnection dssConnection : sqlConnections) {
                logger.info((Object)("Starting to dump objects from " + dssConnection.name));
                FutureProgress.updateState((double)i++);
                try {
                    FutureProgress.AutocloseableFutureProgressState fp2 = FutureProgress.pushAutoCloseableState((String)("Scanning " + dssConnection.name));
                    try {
                        ErrorContext.ACNDC acndc = ErrorContext.pushWithNDC((String)("dump:" + dssConnection.name));
                        try {
                            if (dssConnection instanceof HiveConnection) {
                                this.dumpObjectsFromHiveConnection(dssConnection, ctx);
                                continue;
                            }
                            this.dumpObjectsFromSqlConnection(dssConnection, ctx);
                        }
                        finally {
                            if (acndc == null) continue;
                            acndc.close();
                        }
                    }
                    finally {
                        if (fp2 == null) continue;
                        fp2.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to dump objects of connection " + String.valueOf(dssConnection)), (Throwable)e);
                    InfoMessage.InfoMessages connectionMessages = new InfoMessage.InfoMessages();
                    connectionMessages.withFatalV((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_DUMP_FAILED, "While scanning " + dssConnection.name + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
                    messages.put(dssConnection.name, connectionMessages);
                }
            }
        }
        return messages;
    }

    private void dumpObjectsFromHiveConnection(DSSConnection dssConnection, AuthCtx ctx) throws Exception {
        ConnectionDump dump = new ConnectionDump();
        dump.startDate = DKUDateUtils.isoFormatUTCNow();
        HiveConnection hiveConnection = (HiveConnection)dssConnection;
        TablesDumpBuilder dumpBuilder = new TablesDumpBuilder();
        long start = System.currentTimeMillis();
        ConnectionMetadataDAO.ConnectionMetadata connectionMetadata = this.connectionMetadataDAO.getAll().get(dssConnection.name);
        if (connectionMetadata == null) {
            connectionMetadata = new ConnectionMetadataDAO.ConnectionMetadata();
        }
        connectionMetadata.tableCount = 0;
        connectionMetadata.columnsCount = 0;
        connectionMetadata.foreignKeysCount = 0;
        connectionMetadata.indicesCount = 0;
        try (DSSMetrics.TimeCtx tcxGlobal = DSSMetrics.timeCtx((String)(METRICS_PREFIX + dssConnection.name));){
            List<String> tableNames = null;
            try (FutureProgress.AutocloseableFutureProgressState fp2 = FutureProgress.pushAutoCloseableState((String)"Listing tables");){
                tableNames = this.metastoreInspectionService.newInspector(ctx, null).listHiveTables(null, hiveConnection.getDatabaseName(), ctx, "__DKU_ANY_PROJECT__");
            }
            fp2 = FutureProgress.pushAutoCloseableState((String)"Fetching tables metadata", (double)tableNames.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
            try {
                logger.info((Object)("Done listing " + tableNames.size() + " tables"));
                for (String tableName : tableNames) {
                    FutureProgressState.checkInterrupt();
                    ++connectionMetadata.tableCount;
                    ExternalTable table = new ExternalTable(hiveConnection.name, null, hiveConnection.getDatabaseName(), tableName);
                    table.connectionType = dssConnection.getType();
                    try {
                        TableSchema tableSchema = this.metastoreInspectionService.newInspector(ctx, null).getTableSchema(null, hiveConnection.getDatabaseName(), tableName, new ArrayList<Partition>(), ctx, "__DKU_ANY_PROJECT__");
                        boolean bl = table.isPartitioned = tableSchema.partitionColumns.size() > 0;
                        if (table.isPartitioned) {
                            for (ColumnSchema partitionColumn : tableSchema.partitionColumns) {
                                table.partitionColumns.add(new SQLDatabaseMetadataRetriever.Column(partitionColumn.name, partitionColumn.comment, partitionColumn.type, null));
                            }
                        }
                        List columns = tableSchema.columns;
                        dumpBuilder.addTable(table);
                        for (ColumnSchema column : columns) {
                            ++connectionMetadata.columnsCount;
                            SQLDatabaseMetadataRetriever.ColumnWithLoc cwl = new SQLDatabaseMetadataRetriever.ColumnWithLoc();
                            cwl.tableKey = table.key;
                            cwl.column = new SQLDatabaseMetadataRetriever.Column(column.name, column.comment, column.type, null);
                            dumpBuilder.addColumn(cwl);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to read schema of table " + tableName), (Throwable)e);
                    }
                    FutureProgress.incrementState((double)1.0);
                }
            }
            finally {
                if (fp2 != null) {
                    fp2.close();
                }
            }
        }
        dump.tables = dumpBuilder.getSchema();
        dump.endDate = DKUDateUtils.isoFormatUTCNow();
        try (AutoCloseableLock ignored = NamedLock.acquire((String)ConnectionsDumpService.getConnectionLockName(dssConnection.name));){
            this.dumpToFile(dump, dssConnection.name);
        }
        connectionMetadata.dssConnectionName = dssConnection.name;
        connectionMetadata.lastScanDate = System.currentTimeMillis();
        connectionMetadata.lastScanDuration = System.currentTimeMillis() - start;
        this.connectionMetadataDAO.save(connectionMetadata);
    }

    private void dumpObjectsFromSqlConnection(DSSConnection dssConnection, AuthCtx ctx) throws SQLException, IOException, InterruptedException, DKUSecurityException {
        ConnectionDump dump = new ConnectionDump();
        dump.startDate = DKUDateUtils.isoFormatUTCNow();
        long start = System.currentTimeMillis();
        TablesDumpBuilder databaseSchemaBuilder = new TablesDumpBuilder();
        AbstractSQLConnection sqlConnection = (AbstractSQLConnection)dssConnection;
        SQLDialect dialect = sqlConnection.getDialect();
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(sqlConnection.getConnectionData_NT(ctx, null), ctx, null);){
            ConnectionMetadataDAO.ConnectionMetadata connectionMetadata;
            block79: {
                DatabaseMetaData metaData = conn.getMetaData();
                logger.info((Object)"Obtained connection metadata");
                String connectionNameForStats = dssConnection.name.toLowerCase();
                connectionMetadata = this.connectionMetadataDAO.getAll().get(sqlConnection.name);
                if (connectionMetadata == null) {
                    connectionMetadata = new ConnectionMetadataDAO.ConnectionMetadata();
                }
                connectionMetadata.tableCount = 0;
                connectionMetadata.columnsCount = 0;
                connectionMetadata.foreignKeysCount = 0;
                connectionMetadata.indicesCount = 0;
                assert (!(dssConnection instanceof HiveConnection));
                String globalStatisticsName = METRICS_PREFIX + connectionNameForStats;
                try (DSSMetrics.TimeCtx tcxGlobal = DSSMetrics.timeCtx((String)globalStatisticsName);){
                    FutureProgress.AutocloseableFutureProgressState fp;
                    SQLDatabaseMetadataRetriever metadataRetriever = new SQLDatabaseMetadataRetriever(sqlConnection.name, dssConnection.indexingSettings.indexSystemTables);
                    logger.info((Object)"Fetching tables");
                    try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)(globalStatisticsName + ".tables"));){
                        fp = FutureProgress.pushAutoCloseableState((String)"Fetching tables");
                        try {
                            for (SQLDatabaseMetadataRetriever.Table table : metadataRetriever.getTables(conn, metaData)) {
                                FutureProgressState.checkInterrupt();
                                databaseSchemaBuilder.addTable(new ExternalTable(table.getTableKey(), dssConnection.getType(), table.getRemarks(), table.getType()));
                                ++connectionMetadata.tableCount;
                                if (connectionMetadata.tableCount % 1000 != 0) continue;
                                logger.infoV("Fetched %d tables", new Object[]{connectionMetadata.tableCount});
                            }
                        }
                        finally {
                            if (fp != null) {
                                fp.close();
                            }
                        }
                    }
                    logger.infoV("Done fetching %d tables", new Object[]{connectionMetadata.tableCount});
                    logger.info((Object)"Fetching columns");
                    tctx = DSSMetrics.timeCtx((String)(globalStatisticsName + ".columns"));
                    try {
                        fp = FutureProgress.pushAutoCloseableState((String)"Fetching columns");
                        try {
                            for (SQLDatabaseMetadataRetriever.ColumnWithLoc column : metadataRetriever.getColumns(dialect, metaData, null, null, "%")) {
                                FutureProgressState.checkInterrupt();
                                if (databaseSchemaBuilder.addColumn(column)) {
                                    ++connectionMetadata.columnsCount;
                                }
                                if (connectionMetadata.columnsCount % 1000 != 0) continue;
                                logger.infoV("Fetched %d columns", new Object[]{connectionMetadata.columnsCount});
                            }
                        }
                        finally {
                            if (fp != null) {
                                fp.close();
                            }
                        }
                    }
                    finally {
                        if (tctx != null) {
                            tctx.close();
                        }
                    }
                    logger.infoV("Done fetching %d columns", new Object[]{connectionMetadata.columnsCount});
                    if (dssConnection.indexingSettings.indexForeignKeys) {
                        logger.info((Object)"Fetching foreign keys");
                        tctx = DSSMetrics.timeCtx((String)(globalStatisticsName + ".foreignKeys"));
                        try {
                            fp = FutureProgress.pushAutoCloseableState((String)"Fetching foreign keys");
                            try {
                                for (SQLDatabaseMetadataRetriever.ForeignKey foreignKey : metadataRetriever.getForeignKeys(conn.getConnectionData(), metaData)) {
                                    FutureProgressState.checkInterrupt();
                                    if (databaseSchemaBuilder.addForeignKey(foreignKey)) {
                                        ++connectionMetadata.foreignKeysCount;
                                    }
                                    if (connectionMetadata.foreignKeysCount % 1000 != 0) continue;
                                    logger.infoV("Fetched %d foreign keys", new Object[]{connectionMetadata.foreignKeysCount});
                                }
                            }
                            finally {
                                if (fp != null) {
                                    fp.close();
                                }
                            }
                        }
                        finally {
                            if (tctx != null) {
                                tctx.close();
                            }
                        }
                        logger.infoV("Done fetching %d foreign keys", new Object[]{connectionMetadata.foreignKeysCount});
                    }
                    if (!dssConnection.indexingSettings.indexIndices) break block79;
                    logger.info((Object)"Fetching indices");
                    tctx = DSSMetrics.timeCtx((String)(globalStatisticsName + ".indices"));
                    try {
                        fp = FutureProgress.pushAutoCloseableState((String)"Fetching indices");
                        try {
                            for (SQLDatabaseMetadataRetriever.Index index : metadataRetriever.getIndexes(conn.getConnectionData(), metaData)) {
                                FutureProgressState.checkInterrupt();
                                if (databaseSchemaBuilder.addIndex(index)) {
                                    ++connectionMetadata.indicesCount;
                                }
                                if (connectionMetadata.indicesCount % 1000 != 0) continue;
                                logger.infoV("Fetched %d indices", new Object[]{connectionMetadata.indicesCount});
                            }
                        }
                        finally {
                            if (fp != null) {
                                fp.close();
                            }
                        }
                    }
                    finally {
                        if (tctx != null) {
                            tctx.close();
                        }
                    }
                    logger.infoV("Done fetching %d indices", new Object[]{connectionMetadata.indicesCount});
                }
            }
            dump.tables = databaseSchemaBuilder.getSchema();
            dump.endDate = DKUDateUtils.isoFormatUTCNow();
            logger.info((Object)"Writing dump file");
            try (AutoCloseableLock ignored = NamedLock.acquire((String)ConnectionsDumpService.getConnectionLockName(dssConnection.name));){
                this.dumpToFile(dump, dssConnection.name);
            }
            connectionMetadata.dssConnectionName = dssConnection.name;
            connectionMetadata.lastScanDate = System.currentTimeMillis();
            connectionMetadata.lastScanDuration = System.currentTimeMillis() - start;
            this.connectionMetadataDAO.save(connectionMetadata);
        }
    }

    private static File getFileForConnection(String connectionName) {
        return ApplicationConfigurator.getFile((String[])new String[]{DATA_CATALOG, DUMPS_FOLDER, connectionName + ".json"});
    }

    public void dumpToFile(ConnectionDump dump, String connectionName) throws IOException {
        File dumpFile = ConnectionsDumpService.getFileForConnection(connectionName);
        DKUFileUtils.mkdirsParent((File)dumpFile);
        JSON.prettyToFile((Object)dump, (File)dumpFile);
    }

    public Iterable<ExternalTable> iterateDump(String connectionName) throws IOException {
        return this.readConnectionDump((String)connectionName).tables;
    }

    public ConnectionDump readConnectionDump(String connectionName) throws IOException {
        File dumpFile = ConnectionsDumpService.getFileForConnection(connectionName);
        return (ConnectionDump)JSON.parseFile((File)dumpFile, ConnectionDump.class);
    }

    public Set<String> getScannedConnections() {
        HashSet<String> ret = new HashSet<String>();
        File dir = ApplicationConfigurator.getFile((String[])new String[]{DATA_CATALOG, DUMPS_FOLDER});
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                if (!f.getName().endsWith(".json")) continue;
                ret.add(f.getName().replace(".json", ""));
            }
        }
        return ret;
    }

    public static class ConnectionDump {
        public String startDate;
        public String endDate;
        public Collection<ExternalTable> tables = new ArrayList<ExternalTable>();
    }

    private static class TablesDumpBuilder {
        private Map<DatabaseObjectKey, ExternalTable> tables = new HashMap<DatabaseObjectKey, ExternalTable>();

        private TablesDumpBuilder() {
        }

        void addTable(ExternalTable table) {
            this.tables.put(table.key, table);
        }

        boolean addColumn(SQLDatabaseMetadataRetriever.ColumnWithLoc column) {
            ExternalTable table = this.tables.get(column.tableKey);
            if (table != null) {
                table.columns.add(column.column);
            }
            return table != null;
        }

        boolean addForeignKey(SQLDatabaseMetadataRetriever.ForeignKey foreignKey) {
            ExternalTable fkTable = this.tables.get(foreignKey.fkTableKey);
            ExternalTable pkTable = this.tables.get(foreignKey.pkTableKey);
            if (fkTable != null) {
                fkTable.foreignKeys.add(foreignKey);
            }
            if (pkTable != null) {
                pkTable.foreignKeys.add(foreignKey);
            }
            return fkTable != null || pkTable != null;
        }

        boolean addIndex(SQLDatabaseMetadataRetriever.Index index) {
            ExternalTable table = this.tables.get(index.tableKey);
            if (table != null) {
                table.indexes.add(index);
            }
            return table != null;
        }

        Collection<ExternalTable> getSchema() {
            return this.tables.values();
        }
    }
}

