/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.populardatasets.PopularDatasetsService;
import com.dataiku.dip.populardatasets.UIPopularDataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/popular-datasets"})
public class PopularDatasetsController
extends DIPInternalControllerBase {
    @Autowired
    private PopularDatasetsService popularDatasetsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;

    @AuditedCall(value={"msgType", "compute-most-used-datasets"})
    @RequestMapping(value={"/compute"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<Boolean> compute(HttpServletRequest req, @RequestParam(required=false) GeneralSettingsDAO.PopularDatasetsSettings config) throws Exception {
        GeneralSettingsDAO.PopularDatasetsSettings popularDatasetsSettings;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            popularDatasetsSettings = config == null ? this.generalSettingsDAO.getUnsafe().popularDatasetsSettings : config;
        }
        if (this.popularDatasetsService.havePopularDatasetBeenComputed() || config != null) {
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.popularDatasetsService.startComputation(this.popularDatasetsService.getProcessingOptions(popularDatasetsSettings), authCtx);
    }

    @AuditedCall(value={"msgType", "list-popular-datasets"})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public UIPopularDataset.PopularDatasetList list(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return new UIPopularDataset.PopularDatasetList(this.popularDatasetsService.getPopularDatasetsStatus(), this.popularDatasetsService.getPopularDatasetsForUser_NT(authCtx));
    }
}

