/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.graphicsexport.wikis.WikiExportService;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExport;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ConflictCheckService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.dip.wikis.ArticlesTemplatesService;
import com.dataiku.dip.wikis.Wiki;
import com.dataiku.dip.wikis.WikisDAO;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/projects/wikis"})
public class WikisController
extends DIPInternalControllerBase {
    @Autowired
    private WikisService wikisService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private ArticlesTemplatesService articlesTemplatesService;
    @Autowired
    private ArticlesCacheService articlesCacheService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private WikisDAO wikisDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private ConflictCheckService conflictCheckService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private WikiExportService wikiExportService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.wikis.controller");

    @AuditedCall(value={"msgType", "wiki-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/get-wiki"})
    public void getWiki(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        Wiki.WikiSummary wikiSummary = new Wiki.WikiSummary();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            wikiSummary.wiki = this.wikisService.getWikiUnsafe(projectKey);
            wikiSummary.articleMapping = this.articlesCacheService.getNamesMapping(projectKey);
        }
        try {
            wikiSummary.timeline = this.timelinesService.getWikiTimeline_NT(projectKey, 0, 100);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get Wiki timeline", (Throwable)e);
        }
        WikisController.writeJSON((HttpServletResponse)resp, (Object)wikiSummary);
    }

    @AuditedCall(value={"msgType", "article-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/get-article-summary"})
    public void getArticleSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String articleIdOrName) throws Exception {
        AuthCtx authCtx;
        Article.ArticleSummary summary = new Article.ArticleSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            Article article = this.wikisService.getSmartArticleUnsafe(projectKey, articleIdOrName);
            if (article == null) {
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                throw new NotFoundException(String.format("Article %s does not exist in %s", articleIdOrName, projectKey));
            }
            this.projectsService.checkReadDashboardPerm(authCtx, projectKey, ITaggingService.TaggableType.ARTICLE, article.id);
            summary.object = article;
            summary.payload = this.wikisService.getArticlePayloadOrNull(projectKey, article.id);
            if (summary.object.creationTag != null) {
                summary.createdBy = this.usersService.getPublicUser(summary.object.creationTag.getLastAuthor());
                summary.createdOn = summary.object.creationTag.getLastModifiedOn();
            }
            if (summary.object.versionTag != null) {
                summary.lastModifiedBy = this.usersService.getPublicUser(summary.object.versionTag.getLastAuthor());
                summary.lastModifiedOn = summary.object.versionTag.getLastModifiedOn();
            }
        }
        try {
            summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get Wiki article timeline", (Throwable)e);
        }
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summary.object);
        WikisController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditedCall(value={"msgType", "article-get-payload", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/get-article-payload"})
    public void getArticlePayload(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String articleId) throws Exception {
        JsonObject ret = new JsonObject();
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.ARTICLE, articleId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            ret.addProperty("payload", this.wikisService.getArticlePayloadOrNull(projectKey, articleId));
        }
        WikisController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "article-create", "projectKey", "${projectKey}", "articleName", "${articleName}"})
    @RequestMapping(value={"/create-article"})
    public void createArticle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String articleName, @RequestParam String parent, @RequestParam(required=false) String templateDesc) throws Exception {
        Article article;
        ArticlesTemplatesService.ArticleTemplateDesc template = (ArticlesTemplatesService.ArticleTemplateDesc)JSON.parse((String)templateDesc, ArticlesTemplatesService.ArticleTemplateDesc.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(user);
            article = this.wikisService.createArticle(projectKey, articleName, parent, template);
            t.commitV("Created article %s (%s)", new Object[]{article.getFullId(), article.getDisplayName()});
        }
        WikisController.writeJSON((HttpServletResponse)resp, (Object)article);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/check-save-article-conflict"})
    public void checkSaveConflict(HttpServletRequest req, HttpServletResponse resp, @RequestParam String article) throws Exception {
        Article art = (Article)JSON.parse((String)article, Article.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, art.projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Article existingArticle = (Article)this.articlesDAO.getOrNullUnsafe(art.projectKey, art.id);
            Article newArticle = (Article)JSON.parse((String)article, Article.class);
            VersionTag.ConflictCheckResult ccr = existingArticle != null ? this.conflictCheckService.checkConflict(existingArticle.versionTag, newArticle.versionTag) : this.conflictCheckService.checkConflict(null, newArticle.versionTag);
            if (!ccr.canBeSaved) {
                ccr.message = "This article is being edited by more than one user.";
            }
            WikisController.writeJSON((HttpServletResponse)resp, (Object)ccr);
        }
    }

    @AuditInline
    @RequestMapping(value={"/add-attachment"})
    public void addAttachment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String article, @RequestParam String articleAttachment) throws Exception {
        AuthCtx user;
        Article art = (Article)JSON.parse((String)article, Article.class);
        Article.ArticleSummary summary = new Article.ArticleSummary();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, art.projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(user);
            Article.ArticleAttachment attachment = (Article.ArticleAttachment)JSON.parse((String)articleAttachment, Article.ArticleAttachment.class);
            summary.object = this.wikisService.addAttachment(art, attachment);
            summary.payload = this.wikisService.getArticlePayloadOrNull(art.projectKey, art.id);
            if (summary.object.creationTag != null) {
                summary.createdBy = this.usersService.getPublicUser(summary.object.creationTag.getLastAuthor());
                summary.createdOn = summary.object.creationTag.getLastModifiedOn();
            }
            if (summary.object.versionTag != null) {
                summary.lastModifiedBy = this.usersService.getPublicUser(summary.object.versionTag.getLastAuthor());
                summary.lastModifiedOn = summary.object.versionTag.getLastModifiedOn();
            }
            t.commit(String.format("Added attachment in wiki article %s (%s)", art.getFullId(), art.getDisplayName()), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            this.auditTrailService.generic("wiki-article-save").with("projectKey", art.projectKey).with("articleId", art.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("wiki-article-save", (Throwable)e).with("projectKey", art.projectKey).with("articleId", art.id).emit();
            throw e;
        }
        try {
            summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get Wiki article timeline", (Throwable)e);
        }
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(user, summary.object);
        WikisController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditInline
    @RequestMapping(value={"/delete-attachment"})
    public void deleteAttachment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String article, @RequestParam String articleAttachment) throws Exception {
        AuthCtx user;
        Article art = (Article)JSON.parse((String)article, Article.class);
        Article.ArticleSummary summary = new Article.ArticleSummary();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, art.projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(user);
            Article.ArticleAttachment attachment = (Article.ArticleAttachment)JSON.parse((String)articleAttachment, Article.ArticleAttachment.class);
            summary.object = this.wikisService.deleteAttachment(art, attachment);
            summary.payload = this.wikisService.getArticlePayloadOrNull(art.projectKey, art.id);
            if (summary.object.creationTag != null) {
                summary.createdBy = this.usersService.getPublicUser(summary.object.creationTag.getLastAuthor());
                summary.createdOn = summary.object.creationTag.getLastModifiedOn();
            }
            if (summary.object.versionTag != null) {
                summary.lastModifiedBy = this.usersService.getPublicUser(summary.object.versionTag.getLastAuthor());
                summary.lastModifiedOn = summary.object.versionTag.getLastModifiedOn();
            }
            t.commit(String.format("Deleted attachment in wiki article %s (%s)", art.getFullId(), art.getDisplayName()), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            this.auditTrailService.generic("wiki-article-save").with("projectKey", art.projectKey).with("articleId", art.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("wiki-article-save", (Throwable)e).with("projectKey", art.projectKey).with("articleId", art.id).emit();
            throw e;
        }
        try {
            summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get Wiki article timeline", (Throwable)e);
        }
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(user, summary.object);
        WikisController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditInline
    @RequestMapping(value={"/save-article"})
    public void saveArticle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String article, @RequestParam(required=false) String payload, @RequestParam(required=false) String commitMessage) throws Exception {
        AuthCtx user;
        Article art = (Article)JSON.parse((String)article, Article.class);
        Article.ArticleSummary summary = new Article.ArticleSummary();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, art.projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(user);
            summary.object = this.wikisService.saveArticle(art, payload);
            summary.payload = this.wikisService.getArticlePayloadOrNull(art.projectKey, art.id);
            if (summary.object.creationTag != null) {
                summary.createdBy = this.usersService.getPublicUser(summary.object.creationTag.getLastAuthor());
                summary.createdOn = summary.object.creationTag.getLastModifiedOn();
            }
            if (summary.object.versionTag != null) {
                summary.lastModifiedBy = this.usersService.getPublicUser(summary.object.versionTag.getLastAuthor());
                summary.lastModifiedOn = summary.object.versionTag.getLastModifiedOn();
            }
            if (StringUtils.isNotBlank((String)commitMessage)) {
                t.commit(commitMessage, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.YES);
            } else {
                t.commit(String.format("Saved wiki article %s (%s)", art.getFullId(), art.getDisplayName()), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            }
            this.auditTrailService.generic("wiki-article-save").with("projectKey", art.projectKey).with("articleId", art.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("wiki-article-save", (Throwable)e).with("projectKey", art.projectKey).with("articleId", art.id).emit();
            throw e;
        }
        try {
            summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get Wiki article timeline", (Throwable)e);
        }
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(user, summary.object);
        WikisController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditedCall(value={"msgType", "article-change-parent", "projectKey", "${projectKey}", "id", "${id}", "parentId", "${parentId}"})
    @RequestMapping(value={"/change-article-parent"})
    public void changeArticleParent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String parentId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(user);
            this.wikisService.changeArticleParent(projectKey, id, parentId);
            t.commitV("Changed article %s.%s parent to %s", new Object[]{projectKey, id, parentId});
        }
    }

    @AuditedCall(value={"msgType", "wiki-set-home-article", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/set-home-article"})
    public void setHomeArticle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String homeArticleId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(user);
            Wiki oldWiki = this.wikisService.getWiki(projectKey);
            oldWiki.homeArticleId = homeArticleId;
            this.wikisService.setWiki(oldWiki);
            t.commitV("Set %s's wiki home article", new Object[]{projectKey});
        }
    }

    @AuditedCall(value={"msgType", "wiki-set-taxonomy", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/edit-taxonomy"})
    public void setTaxonomy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String wiki) throws Exception {
        Wiki newWiki = (Wiki)JSON.parse((String)wiki, Wiki.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(user);
            Wiki oldWiki = this.wikisService.getWiki(projectKey);
            oldWiki.taxonomy = newWiki.taxonomy;
            this.wikisService.setWiki(oldWiki);
            t.commitV("Edited %s's wiki taxonomy", new Object[]{projectKey});
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/list-templates"})
    public void listTemplates(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        WikisController.writeJSON((HttpServletResponse)resp, this.articlesTemplatesService.list());
    }

    @AuditedCall(value={"msgType", "wiki-upload", "projectKey", "${projectKey}", "articleId", "${articleId}"})
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public void upload(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String articleId, @RequestParam MultipartFile file) throws Exception {
        Article article;
        Callable<Article.ArticleAttachment> callableUploadHandler;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(authCtx);
            callableUploadHandler = this.wikisService.handleUploadRequest(projectKey, file.getInputStream(), file.getOriginalFilename(), authCtx);
        }
        this.wikisService.checkNewUploadedAttachmentFileExtension(file.getOriginalFilename());
        Article.ArticleAttachment att = callableUploadHandler.call();
        this.wikisService.saveUploadMeta(projectKey, att, file.getOriginalFilename(), authCtx);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            article = this.wikisService.getArticleMandatory(projectKey, articleId);
            this.wikisService.addAttachment(article, att);
            t.commitV("Uploaded file to article %s (%s)", new Object[]{article.getFullId(), article.getDisplayName()});
        }
        WikisController.writeJSON((HttpServletResponse)resp, (Object)new WikisService.ArticleWithRecentAttachment(article, att));
    }

    @AuditedCall(value={"msgType", "wiki-copy", "projectKey", "${projectKey}", "articleId", "${articleId}"})
    @RequestMapping(value={"/copy-article"}, method={RequestMethod.POST})
    public void copyArticle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String articleName, @RequestParam String parent, @RequestParam String originalArticleId, @RequestParam boolean withAttachments) throws Exception {
        String payload;
        Article originalArticle;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, false, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkWriteWikiAllowed(authCtx);
            originalArticle = (Article)this.articlesDAO.getMandatoryUnsafe(projectKey, originalArticleId);
            payload = this.wikisService.getArticlePayloadOrNull(projectKey, originalArticleId);
        }
        Article copyArticle = (Article)JSON.parse((String)JSON.json((Object)originalArticle), Article.class);
        copyArticle.attachments = new ArrayList<Article.ArticleAttachment>();
        if (withAttachments) {
            for (Article.ArticleAttachment att : originalArticle.attachments) {
                if (att.attachmentType != Article.ArticleAttachmentType.FILE) {
                    copyArticle.attachments.add(att);
                    continue;
                }
                Article.ArticleAttachment newAtt = this.wikisService.copyUploadFile(projectKey, att, authCtx);
                copyArticle.attachments.add(newAtt);
                payload = payload.replaceAll("\\((" + projectKey + "\\.)?" + att.smartId + "\\)", "($1" + newAtt.smartId + ")").replaceAll("(/dip/api/projects/wikis/get-uploaded-file/([^\\?]*)\\?projectKey=" + projectKey + "&uploadId=)" + att.smartId, "$1" + newAtt.smartId);
            }
        }
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            copyArticle.id = this.wikisService.createArticle((String)projectKey, (String)articleName, (String)parent, null).id;
            copyArticle.name = articleName;
            this.wikisService.saveArticle(copyArticle, payload);
            t.commitV("Copied article %s (%s) %s", new Object[]{originalArticle.getFullId(), originalArticle.getDisplayName(), withAttachments ? "with attachments" : ""});
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to copy article", (Throwable)e);
            this.wikisService.deleteFileUploads(copyArticle);
            throw e;
        }
        WikisController.writeJSON((HttpServletResponse)resp, (Object)copyArticle);
    }

    @AuditedCall(value={"msgType", "wiki-get", "projectKey", "${projectKey}", "uploadId", "${uploadId}"})
    @RequestMapping(value={"/get-uploaded-file/{filename:.+}"})
    public void getUploadedFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String uploadId, @PathVariable String filename) throws IOException, DKUSecurityException {
        block15: {
            try (Transaction t = this.transactionService.beginRead();){
                if (projectKey != null) {
                    this.permissionsService.checkReadDashboardPermission(this.authService.getMandatoryUserNoXSRF(req), projectKey, null, null);
                }
                long ifModifiedSince = req.getDateHeader("If-Modified-Since");
                WikisService.UploadMeta meta = this.wikisService.getUploadMeta(projectKey, uploadId);
                File file = this.wikisService.getUploadedFile(projectKey, uploadId);
                resp.setDateHeader("Last-Modified", file.lastModified());
                String mimeType = meta.mimeType;
                if (StringUtils.isBlank((String)mimeType) && file.getName().toLowerCase(Locale.ROOT).endsWith(".ipynb")) {
                    mimeType = "application/x-ipynb+json";
                }
                resp.setContentType(mimeType);
                if (!MimeTypesSecurity.isSafeForInlineContentDisposition((String)mimeType)) {
                    resp.setHeader("Content-Disposition", "attachment");
                }
                resp.addDateHeader("Expires", System.currentTimeMillis() + 60000L);
                if (file.lastModified() <= ifModifiedSince) {
                    resp.setStatus(304);
                    break block15;
                }
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
                }
            }
        }
    }

    @AuditedCall(value={"msgType", "article-export", "projectKey", "${projectKey}", "articleId", "${articleId}"})
    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    public void export(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exportFormat, @RequestParam(required=false) String articleId, @RequestParam(required=false, defaultValue="false") Boolean exportChildren, @RequestParam(required=false, defaultValue="false") Boolean exportAttachments) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ExportFormat format = (ExportFormat)JSON.parse((String)exportFormat, ExportFormat.class);
        WikiExport export = articleId == null || articleId.isEmpty() ? new WikiExport(projectKey, format, exportAttachments) : new WikiExport(projectKey, format, articleId, (boolean)exportChildren, (boolean)exportAttachments);
        FutureResponse<ExportResult> futureResponse = this.wikiExportService.export(user, export);
        this.auditTrailService.generic("wiki-export-create").with("ProjectKey", export.projectKey).with("ExportId", export.exportId).emit();
        WikisController.writeJSON((HttpServletResponse)resp, futureResponse);
    }

    @AuditedCall(value={"msgType", "article-download-export", "projectKey", "${projectKey}", "exportId", "${exportId}"})
    @RequestMapping(value={"/download-export"}, method={RequestMethod.GET})
    public void downloadExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exportId) throws Exception {
        File file;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            file = this.wikiExportService.getExportFile(user, projectKey, exportId);
        }
        this.auditTrailService.generic("wiki-export-download").with("ProjectKey", projectKey).with("ExportId", exportId).emit();
        String mimeType = DKUtils.probeContentTypeWithFallback((File)file);
        this.writeFileForDownload(resp, file, mimeType, file.getName());
        this.wikiExportService.clean(projectKey, exportId);
    }

    @AuditedCall(value={"msgType", "wikis-list"})
    @RequestMapping(value={"/list-promoted"})
    public void listPromotedWikis(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean withHomeArticle) throws Exception {
        PromotedWikisList ret = new PromotedWikisList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
                try {
                    long lastModifiedOn;
                    if (!sp.settings.wikiSettings.promoted || !this.permissionsService.hasProjectPrivilege(u, sp.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                    PromotedWikisListItem li = new PromotedWikisListItem();
                    li.projectKey = sp.projectKey;
                    li.projectName = sp.name;
                    if (withHomeArticle) {
                        Wiki wiki = this.wikisDAO.getUnsafe(sp.projectKey);
                        if (StringUtils.isNotBlank((String)wiki.homeArticleId)) {
                            li.homeArticle = new Article.ArticleSummary();
                            li.homeArticle.object = this.wikisService.getArticleMandatoryUnsafe(sp.projectKey, wiki.homeArticleId);
                            li.homeArticle.payload = this.wikisService.getArticlePayloadOrNull(sp.projectKey, wiki.homeArticleId);
                        }
                    }
                    if ((lastModifiedOn = this.wikisService.getLastModifiedOn(sp.projectKey)) != 0L) {
                        li.lastModifiedOn = lastModifiedOn;
                    }
                    li.nbArticles = this.articlesDAO.approximateCount(sp.projectKey);
                    li.projectImageInfo = this.projectsService.getProjectImageInfo(sp);
                    ret.wikis.add(li);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to get promoted wiki info for " + sp.projectKey), (Throwable)e);
                }
            }
        }
        WikisController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "wikis-list-authorized-extensions"})
    @RequestMapping(value={"/list-authorized-extensions"})
    @ResponseBody
    public AuthorizedExtensionsList getAuthorizedExtensions(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        return new AuthorizedExtensionsList(this.wikisService.getAuthorizedExtensions());
    }

    @UIModel
    static class PromotedWikisList {
        List<PromotedWikisListItem> wikis = new ArrayList<PromotedWikisListItem>();

        PromotedWikisList() {
        }
    }

    static class PromotedWikisListItem {
        String projectKey;
        String projectName;
        int nbArticles;
        long lastModifiedOn;
        ProjectsService.ProjectImageInfo projectImageInfo;
        @Nullable
        Article.ArticleSummary homeArticle;

        PromotedWikisListItem() {
        }
    }

    static class AuthorizedExtensionsList {
        Set<String> authorizedExtensionsList;

        public AuthorizedExtensionsList(Set<String> authorizedExtensionsList) {
            this.authorizedExtensionsList = authorizedExtensionsList;
        }
    }
}

