/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.admin;

import com.dataiku.dip.security.AuthorizationMatrix;
import com.dataiku.dip.security.SecurityAuditService;
import com.dataiku.dip.security.audit.IAuditTrailBufferService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminSecurityController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private SecurityAuditService auditService;
    @Autowired
    private IAuditTrailBufferService auditBufferService;
    private static final Logger logger = Logger.getLogger((String)"dku.admin.security");

    @AuditedCall(value={"msgType", "admin-get-authorization-matrix"})
    @RequestMapping(value={"/api/security/get-authorization-matrix"})
    @ResponseBody
    public AuthorizationMatrix getAuthorizationMatrix(HttpServletRequest req) throws Exception {
        AuthorizationMatrix authorizationMatrix;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            authorizationMatrix = this.auditService.getAuthorizationMatrix();
        }
        return authorizationMatrix;
    }

    @AuditedCall(value={"msgType", "admin-get-audit-buffer"})
    @RequestMapping(value={"/api/security/get-audit-buffer"})
    public void getAuditBuffer(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean includeAllCalls) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        AdminSecurityController.writeJSON((HttpServletResponse)resp, (Object)this.auditBufferService.get(includeAllCalls));
    }
}

