/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.eda;

import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.compute.sampling.SamplesService;
import com.dataiku.dip.eda.worksheets.CardComputeService;
import com.dataiku.dip.eda.worksheets.InteractiveQueryService;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.queries.InteractiveQuery;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/eda/card-compute"})
public class CardComputeController
extends DIPInternalControllerBase {
    @Autowired
    UIAuthService authService;
    @Autowired
    CardComputeService cardComputeService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    SamplesService samplesService;
    @Autowired
    InteractiveQueryService interactiveQueryService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.eda.card-compute");

    @AuditedCall(value={"msgType", "statistics-card-compute", "sampleId", "${sampleId}"})
    @RequestMapping(value={"/compute-card-result"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public FutureResponse<CardResult> computeResults(HttpServletRequest req, @RequestParam Card card, @RequestParam(defaultValue="false") boolean cacheOnly, @RequestParam String sampleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            Sample sample = this.samplesService.getSampleIfAccessibleByUser(authCtx, sampleId);
            FutureResponse<CardResult> futureResponse = this.cardComputeService.computeResultsInFuture(authCtx, card, cacheOnly, sample);
            return futureResponse;
        }
    }

    @AuditedCall(value={"msgType", "statistics-interactive-query-run", "sampleId", "${sampleId}"})
    @RequestMapping(value={"/run-interactive-query"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public FutureResponse<InteractiveQuery.InteractiveQueryResult> runInteractiveQuery(HttpServletRequest req, @RequestParam InteractiveQuery query, @RequestParam String sampleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            Sample sample = this.samplesService.getSampleIfAccessibleByUser(authCtx, sampleId);
            FutureResponse<InteractiveQuery.InteractiveQueryResult> futureResponse = this.interactiveQueryService.runInteractiveQueryInFuture(authCtx, sample, query);
            return futureResponse;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/fix-card"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public Card fixCard(HttpServletRequest req, @RequestParam Card card) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            logger.infoV("Fixing card %s", new Object[]{card.id});
            Card card2 = card.fixup();
            return card2;
        }
    }
}

