/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.hive.HProxyKernelHandle;
import com.dataiku.dip.hive.HProxyKernelsManager;
import com.dataiku.dip.recipes.code.scala.ScalaKernelHandle;
import com.dataiku.dip.recipes.code.scala.ScalaKernelsManager;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RecipesIntercomPrivilegedController
extends DIPInternalControllerBase {
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private ScalaKernelsManager scalaKernelsManager;
    @Autowired
    private HProxyKernelsManager hProxyKernelsManager;
    private static Logger logger = Logger.getLogger((String)"dip.pintercom.recipe");

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/recipes/scala-kernel-register"})
    public void registerSEK(HttpServletRequest req, HttpServletResponse resp, @RequestParam String kernelId, @RequestParam int port) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        ScalaKernelHandle kernel = (ScalaKernelHandle)this.scalaKernelsManager.getStarting(kernelId);
        if (kernel == null) {
            throw new IllegalArgumentException("Scala kernel " + kernelId + " not found");
        }
        kernel.onRegister(port);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/recipes/hive-kernel-register"})
    public void registerHPROXY(HttpServletRequest req, HttpServletResponse resp, @RequestParam String kernelId, @RequestParam int port) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        HProxyKernelHandle kernel = (HProxyKernelHandle)this.hProxyKernelsManager.getStarting(kernelId);
        if (kernel == null) {
            throw new IllegalArgumentException("HProxy kernel " + kernelId + " not found");
        }
        kernel.onRegister(port);
    }
}

