/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.MentionEnabledEvent;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.google.gson.JsonObject;
import java.util.Set;

public class DiscussionReplyEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
WorkspaceEvent,
EnrichmentService.Enrichable,
MentionEnabledEvent,
EventWithHumanReadableString,
TaggableObjectEvent {
    public static final String NAME = "discussion-reply";
    public final String projectKey;
    public final String workspaceKey;
    public final ITaggingService.TaggableType objectType;
    public final String objectId;
    public final String discussionId;
    public final String topic;
    public final String text;
    public final boolean creation;
    public final boolean newReply;
    public final String user;
    public JsonObject details;
    public Set<String> mentionedUsers;

    public DiscussionReplyEvent(String projectKey, String workspaceKey, ITaggingService.TaggableType objectType, String objectId, String discussionId, String user, String topic, String text, boolean creation, boolean newReply) {
        this.projectKey = projectKey;
        this.workspaceKey = workspaceKey;
        this.objectType = objectType;
        this.objectId = objectId;
        this.discussionId = discussionId;
        this.user = user;
        this.topic = topic;
        this.text = text.length() < 200 ? text : text.substring(0, 200) + "...";
        this.creation = creation;
        this.newReply = newReply;
        this.details = new JsonObject();
    }

    public String getName() {
        return NAME;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return this.objectType;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public JsonObject getDetails() {
        return this.details;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getWorkspaceKey() {
        return this.workspaceKey;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public String getMessage() {
        return this.text;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        String userLabel = this.details.has("userDisplayName") ? this.details.get("userDisplayName").getAsString() : this.user;
        String objectLabel = this.details.has("objectDisplayName") ? this.details.get("objectDisplayName").getAsString() : this.objectId;
        String objectTypeLabel = this.objectType.toString().toLowerCase().replace("_", " ");
        String markupObjectLink = this.details.has("itemNotFound") ? markup.text(objectLabel) : markup.dssOrWorkspaceObject(this.objectType, this.projectKey, this.objectId, this.workspaceKey, objectLabel, this.discussionId);
        return String.format("%s posted on %s %s - %s: %s", markup.user(this.user, userLabel), markup.text(objectTypeLabel), markupObjectLink, markup.text(this.topic), markup.text(this.text));
    }

    @Override
    public TaggableObjectsService.TaggableObjectRef getTaggableObjectRef() {
        return new TaggableObjectsService.TaggableObjectRef(this.projectKey, this.objectType, this.objectId, this.workspaceKey);
    }
}

