/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.EventWithSeverity;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.notifications.backend.UsersEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ScenarioStateChangeEvent
extends BackendEvent
implements UsersEvent,
UserEvent,
ProjectEvent,
EventWithSeverity,
EventWithHumanReadableString {
    public static final String NAME = "scenario-state-change";
    public final String projectKey;
    public final String scenarioId;
    public final String scenarioName;
    public final String scenarioRunId;
    public final Set<String> initiators;
    private final Map<String, Object> additionalData;
    public final State state;

    public ScenarioStateChangeEvent(String projectKey, String scenarioId, String scenarioRunId, State state, Set<String> initiators, String scenarioName) {
        this(projectKey, scenarioId, scenarioRunId, state, initiators, scenarioName, Collections.emptyMap());
    }

    public ScenarioStateChangeEvent(String projectKey, String scenarioId, String scenarioRunId, State state, Set<String> initiators, String scenarioName, Map<String, Object> additionalData) {
        this.projectKey = projectKey;
        this.scenarioId = scenarioId;
        this.scenarioName = scenarioName;
        this.scenarioRunId = scenarioRunId;
        this.state = state;
        this.initiators = initiators;
        this.additionalData = additionalData;
    }

    public ScenarioStateChangeEvent(String projectKey, String scenarioId, String scenarioRunId, State state, String initiator, String scenarioName) {
        this(projectKey, scenarioId, scenarioRunId, state, Collections.singleton(initiator), scenarioName);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getUserLogin() {
        if (!this.initiators.isEmpty()) {
            return this.initiators.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<String> getUsersLogin() {
        return this.initiators;
    }

    @Override
    public EventWithSeverity.EventSeverity getSeverity() {
        switch (this.state) {
            case FAILED: 
            case ABORTED: {
                return EventWithSeverity.EventSeverity.ERROR;
            }
            case DONE: {
                return EventWithSeverity.EventSeverity.OK;
            }
            case DONE_WITH_WARNING: {
                return EventWithSeverity.EventSeverity.WARNING;
            }
            case NOT_STARTED: 
            case RUNNING: {
                return EventWithSeverity.EventSeverity.NEUTRAL;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        String scenarioMsg = markup.scenario(this.projectKey, this.scenarioId, this.scenarioName);
        String userLogin = this.getUserLogin();
        switch (this.state) {
            case RUNNING: {
                return "Scenario " + scenarioMsg + " started by " + markup.user(userLogin, userLogin);
            }
            case DONE: {
                return "Scenario " + scenarioMsg + " done";
            }
            case DONE_WITH_WARNING: {
                return "Scenario " + scenarioMsg + " done with warnings";
            }
            case FAILED: {
                return "Scenario " + scenarioMsg + " failed";
            }
            case ABORTED: {
                return "Scenario " + scenarioMsg + " aborted";
            }
            case NOT_STARTED: {
                return "?";
            }
        }
        throw new Error("unreachable");
    }

    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public static enum State {
        NOT_STARTED,
        RUNNING,
        DONE,
        DONE_WITH_WARNING,
        FAILED,
        ABORTED;

    }
}

