/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.emails.InvitationEmailBuilder;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.workspaces.WorkspacesService;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkspaceInvitationEmailBuilder
extends InvitationEmailBuilder {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private WorkspacesService workspacesService;
    private final String workspaceKey;

    WorkspaceInvitationEmailBuilder(String workspaceKey) {
        SpringUtils.getInstance().autowire((Object)this);
        this.workspaceKey = workspaceKey;
    }

    @Override
    protected String makeSubject(String productLongName) {
        return "You are invited to join a " + productLongName + " workspace";
    }

    @Override
    protected String makeBody(GeneralSettingsDAO.GeneralSettings generalSettings, String productLongName, @Nullable String senderLogin) throws IOException, TemplateException {
        PublicUser pu;
        VariableLookup lookup = new VariableLookup();
        try (Transaction ignored = this.transactionService.beginRead();){
            pu = senderLogin != null ? this.usersService.getPublicUser(senderLogin) : new PublicUser();
            lookup.addVariable("displayName", this.workspacesService.getRawWorkspaceUnsafe((String)this.workspaceKey).displayName);
        }
        HrefContext href = new HrefContext(generalSettings.studioExternalUrl);
        lookup.addVariable("objectLink", href.workspace(this.workspaceKey));
        lookup.addVariable("objectType", "workspace");
        lookup.addVariable("iconPath", "workspace.png");
        lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)generalSettings.studioExternalUrl) ? null : generalSettings.studioExternalUrl);
        lookup.addVariable("title", this.makeSubject(productLongName));
        lookup.addVariable("senderDisplayName", StringUtils.isNotBlank((String)pu.displayName) ? pu.displayName : pu.login);
        lookup.addVariable("productLongName", productLongName);
        lookup.addVariable("senderEmail", StringUtils.isNotBlank((String)pu.email) ? pu.email : null);
        File templateFile = DKUApp.getResourceFile((String[])new String[]{"notifications", "pending-invite-email.ftl"});
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }
}

